# uvm-ams

# frequency_adapter
Repo for frequency adapter models and UVCs
## Get Started
(optional) Set the UVM environment if you have not:
``$ setenv UVMHOME `xmroot`/tools/methodology/UVM/CDNS-1.2``

The UVM testbench for all versions of the frequency adapter can be run by:
`$ cd tb_comb`

## Using Digital I2C agent:

### Digital DUT
`$ ./run_xrun_dig`
`$ ./run_questa_dig`

### AMS DUT
`$ ./run_xrun_ams`
`$ ./run_symphony_ams`
`$ ./run_vcs_ams`

### DMS DUT
`$ ./run_xrun_dms`
`$ ./run_vcs_dms`

## DMS DUT, DMS I2C agent:
`$ ./run_xrun_i2c_dms`
`$ ./run_vcs_dms_i2c`

## Directory tree:
.
├── includes
│   ├── uvm_ms_pkg.sv
│   │   └── package uvm_ms_pkg
│   │       └── virtual class uvm_ms_proxy   
│   ├── uvm_ms.svh
│   │   ├── define uvm_ms_info
│   │   ├── define uvm_ms_warning
│   │   ├── define uvm_ms_error
│   │   ├── define uvm_ms_fatal
│   │   ├── function void uvm_ms_info
│   │   ├── function void uvm_ms_warning
│   │   ├── function void uvm_ms_error
│   │   └── function void uvm_ms_fatal         
│   └── uvm_ms.vamsh
│       ├── define uvm_ms_info
│       ├── define uvm_ms_warning
│       ├── define uvm_ms_error
│       └── define uvm_ms_fatal
├── README.md
├── src_dig
│   ├── buffer_dig.sv
│   ├── clk_driver_diff_dig.sv
│   ├── freq_adapter_dig.sv
│   ├── freq_div2_dig.sv
│   ├── freq_doubler_dig.sv
│   ├── I2C_registers.sv
│   ├── I2C_target.sv
│   └── mux4to1_dig.sv
├── src_svrnm
│   ├── buffer.sv
│   ├── clk_driver_diff.sv
│   ├── common_functions.sv
│   ├── freq_adapter.sv
│   ├── freq_div2.sv
│   ├── freq_doubler.sv
│   ├── I2C_target_ms.sv
│   ├── mux4to1.sv
│   └── slew.sv
├── src_vams
│   ├── ana_buf.vams
│   ├── clk_driver_diff.vams
│   ├── freq_div2.vams
│   ├── freq_doubler.vams
│   ├── frequency_adapter.vams
│   └── mux4to1.vams
├── tb_comb
│   ├── afs.scs
│   ├── amscf.scs
│   ├── ams.svcf
│   ├── CapGeq0.sv
│   ├── dig.svcf
│   ├── dms.svcf
│   ├── freq_adpt_scoreboard.sv
│   ├── freq_adpt_tb.sv
│   ├── probes_ams.tcl
│   ├── probes_dig.tcl
│   ├── probes_dms.tcl
│   ├── psim.init
│   ├── qrun_ams.f
│   ├── questa_dig.f
│   ├── run_questa_dig
│   ├── run_symphony_ams
│   ├── run_vcs_ams
│   ├── run_vcs_dms
│   ├── run_vcs_dms_i2c
│   ├── run_xrun_ams
│   ├── run_xrun_dig
│   ├── run_xrun_dms
│   ├── run_xrun_i2c_dms
│   ├── test_lib.sv
│   ├── top.sv
│   ├── vcsAD.init
│   ├── vcs_ams.f
│   ├── vcs_dms.f
│   ├── vcs_dms_i2c.f
│   ├── vcs.do
│   ├── vcs_run.f
│   ├── xrun_ams.f
│   ├── xrun_dig.f
│   ├── xrun_dms.f
│   └── xrun_i2c_dms.f
└── uvc_lib
    ├── i2c
    │   └── sv
    │       ├── i2c_agent.sv
    │       │   └── class i2c_agent
    │       ├── i2c_bridge_core.sv
    │       │   └── module i2c_bridge_core
    │       ├── i2c_bridge.sv
    │       │   └── module i2c_bridge
    │       ├── i2c_driver.sv
    │       │   └── class i2c_driver
    │       │       └── class i2c_ms_driver
    │       ├── i2c_env.sv
    │       │   └── class i2c_env
    │       ├── i2c_if.sv
    │       │   └── interface i2c_if
    │       ├── i2c_monitor.sv
    │       │   └── class i2c_monitor
    │       ├── i2c_packet.sv
    │       │   └── class i2c_packet
    │       ├── i2c_pkg.sv
    │       │   └── class i2c_pkg
    │       ├── i2c_proxy.sv
    │       │   └── class i2c_proxy
    │       ├── i2c_seqs.sv
    │       │   └── class i2c_base_seq
    │       │       ├── class r_seq
    │       │       ├── class w_seq
    │       │       ├── class r_invalid_target_id_seq
    │       │       ├── class w_invalid_target_id_seq
    │       │       ├── class r_invalid_reg_id_seq
    │       │       ├── class w_invalid_reg_id_seq
    │       │       ├── class i2c_invalid_id_read_seq
    │       │       ├── class i2c_invalid_reg_addr_seq
    │       │       ├── class i2c_wr_seq
    │       │       ├── class i2c_wrw_seq
    │       │       ├── class i2c_init_seq
    │       │       └── class i2c_rdm_mux_seq
    │       ├── i2c_sequencer.sv
    │       └── state_vars_pkg.sv
    │           └── package state_vars_pkg
    └── osc
        ├── sv
        │   ├── osc_agent.sv
        │   │   └── class osc_agent
        │   ├── osc_bridge_core.sv
        │   │   ├── module osc_bridge_core
        │   │   ├── module clk_generator
        │   │   ├── module clk_detector
        │   │   └── module osc_clk_observer
        │   ├── osc_bridge.sv
        │   │   └── module osc_bridge
        │   ├── osc_driver.sv
        │   │   └── class osc_driver
        │   │       └── class osc_ms_driver
        │   ├── osc_env.sv
        │   │   └── class osc_env
        │   ├── osc_if.sv
        │   │   └── interface osc_if
        │   ├── osc_merged_sequences.sv
        │   │   ├── class osc_base_seq
        │   │   │   └── class osc_nested_seq
        │   │   └── class osc_base_ms_seq
        │   │       ├── class osc_ms_transaction_seq
        │   │       └── class osc_ms_nested_seq
        │   ├── osc_monitor.sv
        │   │   └── class osc_monitor
        │   │       └── class osc_ms_monitor
        │   ├── osc_pkg.sv
        │   │   └── package osc_pkg
        │   ├── osc_proxy.sv
        │   │   └── class osc_proxy
        │   ├── osc_sequencer.sv
        │   │   └── class osc_sequencer
        │   ├── osc_transaction.sv
        │   │   └── class osc_transaction
        │   │       └── class osc_ms_transaction
        │   └── osc_types.sv
        └── vams
            └── osc_bridge_core.vams
                └── module osc_bridge_core

