`timescale 1ns/1ps

module top
`ifdef XRUN
import cds_rnm_pkg::*;
import EE_pkg::*;
`endif

`ifdef QUESTA
import mgc_rnm_pkg::*;
`endif

`ifdef VCS
import snps_msv_nettype_pkg::*;
import viz_package::*;
`endif
;
  
  //Import the UVM library
  import uvm_pkg::*;
  import uvm_ms_pkg::*;

  //Include the UVM macros
  `include "uvm_macros.svh"
  `include "uvm_ms.svh"

  //Import the UVC packages
  import osc_pkg::*;
  import i2c_pkg::*;
  

  //Include the test library file
  `include "freq_adpt_scoreboard.sv"
  `include "freq_adpt_tb.sv"
  `include "test_lib.sv"
  
  // Parameters for supply voltage and pull-up resistance for EEnet I2C
  parameter real Vdd = 1.8;   // Volts
  parameter real Rpu = 4.7e3; // Ohms
  parameter real Rout = 100;  //Ohms
  parameter real Per  = 240;    // ns
  parameter real C    = 2e-12; // (pico) Farads
  parameter real Ts   = 0.5e-9; // seconds

  //Clock and reset signals
  wire clkout_p, clkout_n;
  wire clk_in;
  
  bit scl_drive;
  real per = Per;
  
  bit en_mux;
  bit [1:0] sel_mux;
  bit [1:0] ampl_adj;
  bit [1:0] sr_adj;
  bit [7:0] pw_adj;

  `ifdef DMS_I2C
  wire sda_drive;

`ifdef XRUN
  EEnet SDA, SCL;
`endif
`ifdef VCS
  VIZwire SDA, SCL;
`endif
  `else
  wire SDA, SCL;
  `endif
  
  //Interfaces to the DUT
  osc_if generator_if (); 
  osc_if detector_if ();

  //I2C interface
  `ifdef DMS_I2C
  i2c_if i2c_if(.sda(sda_drive), .scl(scl_drive));
  i2c_bridge i2c_bridge (.sda_drive(sda_drive), .scl_drive(scl_drive), .SDA(SDA), .SCL(SCL));
  `else
  i2c_if i2c_if(.sda(SDA), .scl(SCL));
  `endif

  //Register bank to program the frequency adapter - written to using I2C
  I2C_registers regi(
    .SCL(SCL),
    .SDA(SDA),
    .pw_adj(pw_adj),      //Pulse-width adjustment
    .en_mux(en_mux),      //Mux enable
    .sel_mux(sel_mux),    //Mux selection
    .ampl_adj(ampl_adj),  //Amplitude adjustment
    .sr_adj(sr_adj)       //Slew-rate adjustment
  );

  // clocking
  always #(per/2) scl_drive = ~scl_drive;
  
  //I2C pull-ups and SCL drive
  `ifdef DMS_I2C
  assign SDA = '{Vdd, 0, Rpu}; 
  assign SCL = '{Vdd, 0, Rpu};
  assign (pull1, strong0) sda_drive = 1'b1;
  CapGeq0 #(.c(C), .tinc(Ts)) C_SDA (SDA);
  CapGeq0 #(.c(C), .tinc(Ts)) C_SCL (SCL);
  `else
  assign (pull1, strong0) SDA = 1'b1;
  assign (pull1, strong0) SCL = 1'b1;
  assign SCL = (scl_drive === 1'b0) ? 1'b0 : 1'bz;
  `endif

  //For a pure digital DUT, we are mapping the inputs and outputs directly to the generator and detector
  //interface nets respectively
  //For a mixed-signal DUT (AMS/DMS), we are instantiating MS bridges for the generator and detector UVCs.
  //These will in-turn instantiate analog resources that will perform the generation and detection operations
  //for the UVCs.
  `ifdef UVM_AMS
  osc_bridge #(.diff_sel(0)) generator_bridge (.osc_clk(clk_in), .osc_clk_p(), .osc_clk_n());
  osc_bridge #(.diff_sel(1), .passive(1)) detector_bridge  (.osc_clk(), .osc_clk_p(clkout_p), .osc_clk_n(clkout_n));
  `else
  assign clk_in = generator_if.osc_clk;
  assign detector_if.osc_clk_p = clkout_p;
  assign detector_if.osc_clk_n = clkout_n;
  `endif

  //Frequency Adapter DUT
  frequency_adapter #(.vsup(1.0)) DUT(
    .clk_in   (clk_in),
    .clkout_p (clkout_p),
    .clkout_n (clkout_n),
    .en_mux   (en_mux),
    .pw_adj   (pw_adj),
    .sel_mux  (sel_mux),
    .ampl_adj (ampl_adj),
    .sr_adj   (sr_adj)
  );
  
  initial begin
    $timeformat(-15, 5, " fs", 10); //Setting time precision for UVM report macros
    run_test();
  end

endmodule : top
