// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level Layer-1
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//                Yann Bajot, Prosilog, bajot@prosilog.com
//
//  Description : Transaction Level - Layer-1 example Slave  (OCP2.0)
//  $Id: ocp_tl1_slave_sync.h,v 1.1.1.1 2004/09/24 09:26:16 sguntz Exp $
//
// ============================================================================

#ifndef _OCP_TL1_SLAVE_SYNC_H
#define _OCP_TL1_SLAVE_SYNC_H

#include "systemc.h"

#include "ocp_globals.h"
#include "ocp_tl1_slave_if.h"

#define TL_SLAVE_FIFO_DEPTH 256

// Timings are defined in the testbench (top*.cpp)
extern const sc_time_unit TL_TIME_UNIT; 
extern const double TL_CLK_PERIOD ;     // clock period

template <class TdataCl> class OCP_TL1_Slave_sync
  : public sc_module
  , public SdirectIF<TdataCl>
{
public:  

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  sc_port<OCP_TL1_SlaveIF<TdataCl>, 1> SlaveP;
  sc_in_clk clk;

  SC_HAS_PROCESS(OCP_TL1_Slave_sync);

  // constructor
  OCP_TL1_Slave_sync(sc_module_name name_
             , int ID
             , Ta StartAddress
             , Ta EndAddress
             , double RequestDelay
             , double ResponseDelay
            );

  // destructor
  ~OCP_TL1_Slave_sync();

  // methods
  virtual bool MputDirect(int, bool, Td*, Ta, int);
  void Request();
  void Response();

private :

  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl          *m_DataCl;
  ParamCl<TdataCl> *m_ParamCl;
  CommCl           *m_CommCl;


  // Structures used to handle TL1 Requests/Responses
  OCPResponseGrp<Td>   TL1_response;
  OCPRequestGrp<Td,Ta>   TL1_request;

  // parameters
  int m_ID;
  Ta m_StartAddress;
  Ta m_EndAddress;

  // constants
  int m_NumWordsPerBeat;
  int m_SmemoryLength;

  // data
  Td *m_SlaveMemory;

  // request-response synchronization
  bool m_RespEventS[TL_SLAVE_FIFO_DEPTH];
  sc_event m_RespEvent;

  // Signal delays
  double m_RequestDelay;
  double m_ResponseDelay;
};

#endif
