// 
//  (c) Copyright OCP-IP 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia, Inc,
//		  Tim Kogel, CoWare, Inc
//          $Id:
//
//  Description : TLM TL3 Master Interface
//
// ============================================================================


#ifndef _OCP_TL3_MASTER_IF
#define _OCP_TL3_MASTER_IF

#include "systemc.h"

//----------------------------------------------------------------------
//  uni-directional request interfaces
//----------------------------------------------------------------------

template <typename REQ>
class OCP_TL3_MasterRequestIF :  virtual public sc_interface
{
public:
  // Message access 
  virtual bool sendRequest(const REQ& req) = 0;
  virtual bool sendRequest(const REQ& req, const sc_time& time) = 0;
  virtual bool sendRequest(const REQ& req, const int cycles) = 0;

  virtual bool sendRequestBlocking(const REQ& req) = 0;

  virtual bool requestInProgress(void) const = 0;
    
  // Event access
  virtual const sc_event& RequestStartEvent(void) const = 0;
  virtual const sc_event& RequestEndEvent(void) const = 0;
};

//----------------------------------------------------------------------
//  uni-directional response interfaces
//----------------------------------------------------------------------

template <typename RESP>
class OCP_TL3_MasterResponseIF : virtual public sc_interface
{
public:
  // Message access
  virtual bool getResponse(RESP& resp) = 0;
  virtual bool getResponseBlocking(RESP& resp) = 0;
  
  virtual bool acceptResponse(void) = 0;
  virtual bool acceptResponse(const sc_time& time) = 0;
  virtual bool acceptResponse(const int cycles) = 0;

  virtual bool responseInProgress(void) const = 0;

  // Event access
  virtual const sc_event& ResponseStartEvent(void) const = 0; 
  virtual const sc_event& ResponseEndEvent(void) const = 0; 
};


//----------------------------------------------------------------------
// bi-directional composition interfaces
//----------------------------------------------------------------------


template 
<
  typename REQ,
  typename RESP
>
class OCP_TL3_MasterIF :  
  public OCP_TL3_MasterRequestIF<REQ>,
  public OCP_TL3_MasterResponseIF<RESP> 
{
};

#endif // _OCP_TL3_MASTER_IF

