// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         $Id: slave_nb.h,v 1.1 2005/05/21 00:36:54 anssi Exp $
//
//  Description : OCP - TL1 example non-blocking Slave
//
// ============================================================================

#ifndef _OCP_TL1_SLAVENB_SYNC_H
#define _OCP_TL1_SLAVENB_SYNC_H
#define DEBUG_G1
#include <iostream>
#include "channel_types.h"

// OCP-IP Channel header files
#include "ocp_tl1_slave_port.h"
#include "ocp_tl_param_cl.h"

template <typename TdataCl>
class SlaveNb : public sc_module {
public:  

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  OCP_TL1_SlavePort<TdataCl> tpP;

  sc_in<bool> clk;

  SC_HAS_PROCESS(SlaveNb);

  // constructor
  SlaveNb(sc_module_name name_);

  // destructor
  ~SlaveNb();

  // Threads
  void proc();

  // OCP request group
  OCPRequestGrp<Td,Ta> req;

  // OCP response group
  OCPResponseGrp<Td> resp;

  bool is_req;
  bool tmp;
  int last_request;

};

#endif
