// 
//  (c) Copyright OCP-IP 2006
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Tim Kogel, CoWare, Inc
//          $Id:
//
//  Description : declaration of simple OCP TL3 bus
//
// ============================================================================

#ifndef _OCP_TL3_BUS_H
#define _OCP_TL3_BUS_H

#include <systemc.h>
#include "ocp_tl3_channel.h"  
#include "ocp_tl3_master_multi_port.h"  
#include "ocp_tl3_slave_multi_port.h"  
#include "basic_protocol.h"

#define TL3_MAX_INITIATORS     32
#define TL3_MAX_TARGETS      32 

template <class Td, class Ta>
class ocp_tl3_bus
  : public sc_module
{
public:
  typedef basic_protocol::basic_request<Td,Ta>  requestType;
  typedef basic_protocol::basic_response<Td> responseType;

  typedef OCP_TL3_SlaveIF<requestType,responseType> slaveIfType;
  typedef OCP_TL3_MasterIF<requestType,responseType> masterIfType;

  // OCP-specific TL3 specialized slave port:
  //  sc_port<slaveIfType,TL3_MAX_INITIATORS> ocp_s;

  // OCP-specific TL3 specialized master ports:
  //  sc_port<masterIfType, TL3_MAX_TARGETS > ocp_m;

  OCP_TL3_SlaveMultiPort<requestType,responseType>  ocp_s;
  OCP_TL3_MasterMultiPort<requestType,responseType> ocp_m;
        
  // this module has SC processes
  SC_HAS_PROCESS(ocp_tl3_bus);
  
  // --------------------------------------------------------------------
  void request_thread();
  void response_thread();
   
  // -----------------------------------------------------------------------
  // constuctor
  // ---------------------------------------------------------------------
  ocp_tl3_bus(sc_module_name mod, 
	      unsigned int nbr_intiators, 
	      unsigned int nbr_targets);
    
  void end_of_elaboration();
private:
  // -----------------------------------------------------------------------
  // Internal class members 
  // -----------------------------------------------------------------------

  // OCP Request/Response structures
  requestType	m_req;
  responseType	m_resp;
  
  unsigned int	m_index;
  unsigned int	m_previous_read_index;
  int		m_outstanding_reads;
  sc_event	m_resp_event;
  sc_time	m_clk_period;
  sc_fifo<unsigned int> m_fifo;

  const unsigned int	m_nbr_initiators;
  const unsigned int	m_nbr_targets;
};

#include "ocp_tl3_bus.cpp"
#endif
