// 
//  Copyright 2005 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: master.cc,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Master::Master (sc_module_name name_): 
  sc_module (name_), ipP("ipPort") {

  // initialize common members
  cnt = 0;
  req.MAddr = 0;
  req.MBurstSingleReq = 0;
  req_data.MDataByteEn = 0xF;
  wraplen = 0;
  addr = 0;
  read = false;
  protbits = 0;
  burstcnt = 0;
  srmd_cont = false;
  SC_METHOD(proc);
  sensitive_pos(clk); 
  dont_initialize();
  
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Master::~Master() {}

// ----------------------------------------------------------------------------
//  Method : Master::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
void Master::proc() {
  bool tmp;

  // check if request data channel is free
  tmp = !ipP->getSBusyDataHS();
  if (tmp) {
    if (!req_fifo.empty()){
      // Send data if request group has been already sent

      req_data.MData = req_fifo.peek();
      tmp = ipP->startOCPDataHS(req_data);
      if (tmp) {
	req_fifo.read(); // pop fifo if success

#ifdef DEBUG_G1
      cout << "Master sent data "
	   << "  time  = " << sc_time_stamp().to_seconds()
	   << "  MData  = " << req_data.MData << endl;
#endif

      }
    }
  }

  // check if request channel is free
  tmp = !ipP->getSBusy();
  if (tmp || srmd_cont) {
    if (cnt<16) {
      if (!read) {
	wraplen = 0;
	// Set OCP command type
	req.MCmd = OCP_MCMD_WR;
	req.MReqInfo = protbits;
	req.MBurstSeq = OCP_MBURSTSEQ_INCR;
	req.MAddr = addr;
	req.MBurstLength = 8;
	if (burstcnt==7) {
	  burstcnt=0;
	  read = true;
	}
	else {
	  burstcnt++;
	}	
      }
      else {
	wraplen = 0;
	// Set OCP command type
	req.MCmd = OCP_MCMD_RD;
	req.MReqInfo = protbits;
	req.MBurstSeq = OCP_MBURSTSEQ_INCR;
	req.MAddr = addr & (~0x20);
	req.MBurstLength = 8;
	if (burstcnt==7) {
	  burstcnt=0;
	  read = false;
	}
	else {
	  burstcnt++;
	}	
      }
    }
    else if (cnt<25){ 
      if (!read) {// SRMD write
	wraplen = 0; 
	req.MCmd = OCP_MCMD_WR;
	req.MReqInfo = protbits;
	req.MBurstSeq = OCP_MBURSTSEQ_INCR;
	req.MAddr = addr;
	req.MBurstLength = 8;
	req.MBurstSingleReq = 1;
	if (burstcnt==7) {
	  burstcnt=0;
	  read = true;
	}
	else {
	  burstcnt++;
	}
      }
      else {
	wraplen = 0; 
	req.MCmd = OCP_MCMD_RD;
	req.MReqInfo = protbits;
	req.MBurstSeq = OCP_MBURSTSEQ_INCR;
	req.MAddr = addr;
	req.MBurstLength = 8;
	req.MBurstSingleReq = 1;
	if (burstcnt==7) {
	  burstcnt=0;
	}
	else {
	  burstcnt++;
	}
      }
    }

    else {
      req.MCmd = OCP_MCMD_IDLE;
      burstcnt = 0;
    }
  

    // Send request
    if ((req.MBurstSingleReq && burstcnt==1) ||
	!req.MBurstSingleReq) {
      if (req.MBurstSingleReq)
	srmd_cont = true;
      if (req.MCmd != OCP_MCMD_IDLE)
	tmp = ipP->startOCPRequest(req);
      else
	tmp = false;

      if (tmp) {
	
#ifdef DEBUG_G1
	cout << "Master sent request "
	     << "  time  = " << sc_time_stamp().to_seconds()
	     << "  MAddr  = " << req.MAddr << endl;
#endif
	
	if (req.MCmd == OCP_MCMD_WR) {
	  req_fifo.write(addr); // This fifo is deeper than slave's
	}
	// Address generator
	if (wraplen) {
	  if ((addr+4) < ((addr & (~(wraplen-1)*4))+ wraplen*4))
	    addr = addr+4; 
	  else
	    addr = addr & (~((wraplen-1)*4));
	}
	else
	  if (addr < 124)
	    addr += 4;
	  else
	    addr = 0;
	
	cnt++;
      }
    }
    else if (req.MCmd == OCP_MCMD_WR) { // for SRMD data requests
      cnt++;
      req_fifo.write(addr++); 
      if (burstcnt==0) 
	srmd_cont = false;
    }
  }
  
  // Check for response
  tmp = ipP->getOCPResponse(resp, true);
  if (tmp) {
    if (resp.SResp == OCP_SRESP_DVA) {

#ifdef DEBUG_G1
      cout << "Master got valid response "
	   << "  time  = " << sc_time_stamp().to_seconds()
	   << "  SResp  = " << resp.SResp
	   << "  SData  = " << resp.SData << endl;
#endif

    }
  }
  
} // end of method



