// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, Generic Transaction Level Layer-1
//       Author : Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//         Date : 12/12/2003
//
//  Description : Transaction Level - Layer-1 example Slave
//
// ============================================================================

#ifndef _OCP_TL1_SLAVE_SYNC_H
#define _OCP_TL1_SLAVE_SYNC_H

#include "ocp_tl1_globals.h"
#include "tl_slave_if.h"

// could be used to configure the data class, not needed in this example
#ifndef TL_SYNCHRON_DATA_CL
#define TL_SYNCHRON_DATA_CL true
#endif

template <class TdataCl> class OCP_TL1_Slave_Sync
  : public sc_module
  , public SdirectIF<TdataCl>
{
public:  

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  sc_port<TLslaveIF<TdataCl>, 1> SlaveP;
  sc_in_clk clk;

  SC_HAS_PROCESS(OCP_TL1_Slave_Sync);

  // constructor
  OCP_TL1_Slave_Sync(sc_module_name name_
             , int ID
             , Ta StartAddress
             , Ta EndAddress
            );

  // destructor
  ~OCP_TL1_Slave_Sync();

  // methods
  virtual bool MputDirect(int, bool, Td*, Ta, int);
  void Release();
  void Request();
  void Response();

private :

  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl          *m_DataCl;
  ParamCl<TdataCl> *m_ParamCl;
  CommCl           *m_CommCl;

  // parameters
  int m_ID;
  Ta m_StartAddress;
  Ta m_EndAddress;

  // constants
  int m_NumWordsPerBeat;
  int m_SmemoryLength;

  // data
  Td *m_SlaveMemory;
  int m_Pause;

  // request-response synchronization
  bool m_RespEventS[TL_SLAVE_FIFO_DEPTH];
  sc_event m_RespEvent;
};

#endif
