////////////////////////////////////////////////////////////////////////
//                                                                    //
//  (c) Copyright OCP-IP 2003
//  OCP-IP Confidential and Proprietary
//                                                                    //
// Joe Chou, Sonics Inc., joechou@sonicsinc.com                       //
// Alan Kamas, for Sonics Inc., aok@sonicsinc.com, www.kamas.com      //
//                                                                    //
//                                                                    //
////////////////////////////////////////////////////////////////////////

#ifndef _ocp20MasterSysC_h
#define _ocp20MasterSysC_h

#include <iostream>
#include <deque>
#include "stdlib.h"
#include "channel_types.h"

// OCP-IP Channel header files
#include "ocp_globals.h"
#include "ocp_tl1_master_port.h"
#include "ocp_tl_param_cl.h"

// define the Master transactor class
template <typename TdataCl>
class MasterSysC : public sc_module
{
  public:
    // --------------------------
    // public members and methods
    // --------------------------

    // type definitions
    typedef typename TdataCl::DataType Td;
    typedef typename TdataCl::AddrType Ta;

    // member definitions

    // channel port
    OCP_TL1_MasterPort<TdataCl> ipP;

    // NOTE: Clock ports not used in this simple example
    // OCP clock port
    // sc_in_clk ocpClkP;

    // NOTE: Clock ports not used in this simple example
    // module clock port
    // sc_in_clk clkP;

    // SystemC macros
    // has SystemC processes
    SC_HAS_PROCESS(MasterSysC);

    // constructor and destructor
    MasterSysC(sc_module_name, double, sc_time_unit, int, ostream* debug_os_ptr = NULL);
    ~MasterSysC();

    // methods
    void setConfiguration( MapStringType& passedMap );

    // process methods
    void requestThreadProcess();
    void dataHSThreadProcess();
    void responseThreadProcess();
    void exerciseSidebandThreadProcess();

  protected:
    // ---------------------------
    // private members and methods
    // ---------------------------

    // SystemC methods
    void end_of_elaboration();

    // member definitions

    // master identification
    int          m_ID;

    // ocp clock information
    double       m_ocpClkPeriod;
    sc_time_unit m_ocpClkTimeUnit;

    // a queue for data handshake data waiting to go out.
    deque< OCPDataHSGrp<Td> > m_dataQ;
    sc_event m_newDataEvent;

    // The current value of the MThreadBusy signal (if any)
    unsigned int m_curMThreadBusy;

    // Debug log file
    ostream* m_debug_os_ptr;

    // Parameters from the OCP Channel:

    // Class that holds all OCP parameters
    ParamCl<TdataCl>* m_OCPParamP;

    // The number of threads
    int m_threads;
    
    // is MAddrSpace part of the OCP channel?
    bool m_addrspace;

    // is SThreadBusy part of the channel?
    bool m_sthreadbusy;

    // Is SThreadBusy compliance required?
    bool m_must_use_sthreadbusy;

    // is SDataThreadBusy part of the channel?
    bool m_sdatathreadbusy;

    // Is SDataThreadBusy compliance required?
    bool m_sdatathreadbusy_exact;

    // is MThreadBusy part of the channel?
    bool m_mthreadbusy;

    // Is MThreadBusy compliance required?
    bool m_must_use_mthreadbusy;

    // is MRespAccept part of the channel?
    bool m_respaccept;

    // is Data Handshake part of the channel?
    bool m_datahandshake;

    // is write response part of the channel?
    bool m_writeresp_enable;

    // is the READ-EX command part of the channel
    bool m_readex_enable;

    // Are non-posted writes (write commands that receive responses) part of the channel?
    bool m_writenonpost_enable; 

    // Given the width of the MBurstLength field, the longest possible burst
    int m_max_burst_len;

    // is MBurstSeq part of the OCP channel?
    bool m_burstseq;

    // is MBurstSingleReq part of the OCP channel?
    bool m_burstsinglereq;

    // amount to increment the address by for each INCR transfer in a burst
    int m_address_incr;

    //-----------------------------------------
    //  Master Specific Parameters
    //-----------------------------------------

    // Response delay style - fixed or random
    bool m_respaccept_fixeddelay;

    // Delay in accepting responses (max delay for random)
    int m_respaccept_delay;

    // Number of times to repeat the built-in set of requests.
    // (a value of 0, the default, is to repeat forever)
    int m_command_cycles;
    
    // Map of string to string that holds the Master's paramter values
    MapStringType m_ParamMap;

};

#endif // _ocp20MasterSysC_h
