// 
// Copyright 2003 OCP-IP
// OCP-IP Confidential & Proprietary
//
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level 
//       Author : Yann Bajot , Prosilog , bajot@prosilog.com
//              : Alan Kamas, for Sonics, Inc., aok@sonicsinc.com, www.kamas.com
//         Date : 09/09/2003
//
//  Description : OCP TL2 Master port declaration.
//                These methods are implemented in the Channel
//                (see ocp_tl2_channel.h)
//
// ============================================================================

#ifndef OCP_TL2_MASTERPORT_H
#define OCP_TL2_MASTERPORT_H

#include "systemc/communication/sc_event_finder.h"
#include "ocp_tl2_master_if.h"


template <class Tdata, class Taddr> class OCP_TL2_MasterPort
: public sc_port< OCP_TL2_MasterIF<Tdata, Taddr> >
{
    public:

        // Constructor
        OCP_TL2_MasterPort(const char* name)
            : sc_port< OCP_TL2_MasterIF<Tdata, Taddr> >(name)
        {
            // do nothing
        }

        // Access to the "in-band" events of the OCP TL2 Channel using event finders
	sc_event_finder& RequestStartEvent() const { return *new sc_event_finder_t<OCP_TL2_MasterIF<Tdata, Taddr> >( *this, &OCP_TL2_MasterIF<Tdata, Taddr>::RequestStartEvent ); }
	sc_event_finder& RequestEndEvent() const { return *new sc_event_finder_t<OCP_TL2_MasterIF<Tdata, Taddr> >( *this, &OCP_TL2_MasterIF<Tdata, Taddr>::RequestEndEvent ); }
	sc_event_finder& ResponseStartEvent() const { return *new sc_event_finder_t<OCP_TL2_MasterIF<Tdata, Taddr> >( *this, &OCP_TL2_MasterIF<Tdata, Taddr>::ResponseStartEvent ); }
	sc_event_finder& ResponseEndEvent() const { return *new sc_event_finder_t<OCP_TL2_MasterIF<Tdata, Taddr> >( *this, &OCP_TL2_MasterIF<Tdata, Taddr>::ResponseEndEvent ); }

        // Access to the SThreadBusyEvent event of the OCP TL2 Channel using event finders
	sc_event_finder& SThreadBusyEvent() const { return *new sc_event_finder_t<OCP_TL2_MasterIF<Tdata, Taddr> >( *this, &OCP_TL2_MasterIF<Tdata, Taddr>::SThreadBusyEvent ); }

        // Access to the Sideband events of the OCP TL2 Channel using event finders
	sc_event_finder& SidebandSlaveEvent() const { return *new sc_event_finder_t<OCP_TL2_MasterIF<Tdata, Taddr> >( *this, &OCP_TL2_MasterIF<Tdata, Taddr>::SidebandSlaveEvent ); }
	sc_event_finder& SidebandResetEvent() const { return *new sc_event_finder_t<OCP_TL2_MasterIF<Tdata, Taddr> >( *this, &OCP_TL2_MasterIF<Tdata, Taddr>::SidebandResetEvent ); }
	sc_event_finder& SidebandControlEvent() const { return *new sc_event_finder_t<OCP_TL2_MasterIF<Tdata, Taddr> >( *this, &OCP_TL2_MasterIF<Tdata, Taddr>::SidebandControlEvent ); }
	sc_event_finder& SidebandStatusEvent() const { return *new sc_event_finder_t<OCP_TL2_MasterIF<Tdata, Taddr> >( *this, &OCP_TL2_MasterIF<Tdata, Taddr>::SidebandStatusEvent ); }
};

#endif   // OCP_TL2_MASTERPORT_H

