// (c) Copyright OCP-IP 2004
// OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Alan Kamas, for Sonics Inc.
//                Joe Chou, Sonics Inc.
//         $Id: ocp_mon_dummy.h,v 1.4 2004/10/04 19:51:26 Anssi Exp $
//
//  Description : Dummy OCP monitor, prints out an error message to a file
//
//  Change History:
//          03/26/2004 Original revision
//          10/04/2004 Updated for channel release 2.0.3
// ============================================================================

#ifndef _OCP_MON_H
#define _OCP_MON_H
#include <iostream>
#include <iomanip>
#include <string>
#include <bitset>
#include "ocp_globals.h"
#include "ocp_tl_param_cl.h"

// forward declaration needed for the class below:
template <class TdataCl> class OCP_TL1_Channel;

template<typename TdataCl>
class OCPMon : public sc_module
{
 public:
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;
  
  OCPMon(sc_module_name mn,
	 OCP_TL1_Channel<TdataCl> *myChannel,
	 std::string monFileName = "",
	 sc_clock * clk = NULL,
	 bool print_params = true)
    : sc_module(mn), m_channel(myChannel)
  {    
    monFile << "OCP Monitor not installed. See www.ocpip.org." << endl;
    monFile.close();
  }

  OCPMon(sc_module_name mn,
	 OCP_TL1_Channel<TdataCl> *myChannel,
	 std::string monFileName = "",
	 sc_in_clk * clk = NULL,
	 bool print_params = true)
    : sc_module(mn), m_channel(myChannel)
  {
    monFile << "OCP Monitor not installed. See www.ocpip.org." << endl;    
    monFile.close();
  }

  OCPMon(sc_module_name mn,
	 OCP_TL1_Channel<TdataCl> *myChannel,
	 std::string monFileName = "",
	 sc_signal<bool> * clk = NULL,
	 bool print_params = true)
    : sc_module(mn), m_channel(myChannel)
  {
    monFile << "OCP Monitor not installed. See www.ocpip.org." << endl;    
    monFile.close();
  }

  OCPMon(sc_module_name mn,
	 OCP_TL1_Channel<TdataCl> *myChannel,
	 double clock_period = 1,
	 sc_time_unit clock_time_unit = SC_NS,
	 std::string monFileName = "",
	 bool print_params = true)
    : sc_module(mn), m_channel(myChannel)
  {
    monFile << "OCP Monitor not installed. See www.ocpip.org." << endl;    
    monFile.close();
  }

  ~OCPMon()  {}

  void startup()
  {
    //do nothing
  }

  void runcheck ()
  {
    // for future
  }
 
  OCP_TL1_Channel<TdataCl> *m_channel;
  ofstream monFile;
};

#endif
