// 
//  Copyright 2005 OCP-IP
//  OCP-IP Confidential and Proprietary
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: main.cc,v 1.4 2005/07/11 16:00:44 tkogel Exp $
//
//  Description : OCP API - TL1 profile example
//
// ============================================================================

// Turn on user messages
//#define DEBUG_G1

// Turn off OCP protocol checker, if installed
#define NDEBUG

// Include SystemC
#include "systemc.h"

// Include OCP files
#include "ocp_tl1_data_cl.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_channel_clocked.h"

// Include user-defined headers
#include "channel_types.h"
#include "command_line.h"

// Include submodules
#include "master.h"
#include "slave.h"

int sc_main(int argc, char* argv[]) {

  // OCP parameters
  MapStringType  ocpParamMap;
  string ocpParamFileName;

  sc_clock clk;

  // Read command line parameters
  process_command_line(argc,argv,ocpParamFileName);

  // Read OCP parameters from file
  if ( ! ocpParamFileName.empty() ) {
    readMapFromFile(ocpParamFileName, ocpParamMap);
  }

  // OCP channel declaration. Allows clocked blocking calls, and OCP trace monitor (if installed)
  typedef  OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> data_type;
  typedef  OCP_TL1_Channel_Clocked< data_type > channel_type;
  channel_type ch0("ocp0","ocp0.ocp");

  // Submodules
  Slave sl1("sl1");
  Master ms1("ms1");

  // Set OCP configuration
  ch0.setConfiguration(ocpParamMap);

  // netlist
  ch0.p_clk(clk);

  ms1.ipP(ch0);
  ms1.clk(clk);
  
  sl1.tpP(ch0);
  sl1.clk(clk);

  // Simulator
  sc_start(50000, SC_NS);
  
  return(0);
}
