// 
//  Copyright 2004 OCP-IP
//  OCP-IP Confidential and Proprietary
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         $Id: main.cc,v 1.4 2005/07/09 18:00:55 Anssi Exp $
//
//  Description : OCP API - Layer-1 Simple Example
//                Top level, synchronous Master <---> synchronous Slave
//
// ============================================================================

// Turn on user messages
//#define DEBUG_G1

// Turn off OCP protocol checker, if installed
#define NDEBUG

// Include SystemC
#include "systemc.h"

// Include OCP files
#include "ocp_tl1_data_cl.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_channel.h"

// Include user-defined headers
#include "channel_types.h"
#include "command_line.h"

// Include submodules
#include "master.h"
#include "slave.h"

int sc_main(int argc, char* argv[]) {

  // OCP parameters
  MapStringType  ocpParamMap;
  string ocpParamFileName;

  sc_clock clk;
  sc_signal<OCPRequestGrp<OCPCHANNELBit32, OCPCHANNELBit32> > t;

  // Read command line parameters
  process_command_line(argc,argv,ocpParamFileName);

  // Read OCP parameters from file
  if ( ! ocpParamFileName.empty() ) {
    readMapFromFile(ocpParamFileName, ocpParamMap);
  }

  // OCP channel declaration. Allows clocked blocking calls, and OCP trace monitor (if installed)
  OCP_TL1_Channel< OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > ch0((std::string)"ocp0",(sc_clock *)&clk, (std::string)"ocp0.ocp");

  // Submodules
  Slave<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > sl1("sl1");
  Master<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > ms1("ms1");

  // Set OCP configuration
  ch0.setConfiguration(ocpParamMap);

  // netlist
  ms1.ipP(ch0);
  ms1.clk(clk);
  
  sl1.tpP(ch0);
  sl1.clk(clk);
  sl1.t(t);

  // Simulator
  sc_start(50000, SC_NS);
  
  return(0);
}
