// 
//  Copyright 2005 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: master_w.cc,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
// ============================================================================

#include "master_w.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Master_w::Master_w (sc_module_name name_): 
  sc_module (name_), ipP("ipPort") {

  // initialize common members
  cnt = 0;
  req.MAddr = 0;
  req.MBurstSingleReq = 0;
  req_data.MDataByteEn = 0xF;
  wraplen = 0;
  addr = 0;
  protbits = 0;
  burstcnt = 0;
  srmd_cont = false;
  SC_METHOD(proc);
  sensitive_pos(clk); 
  dont_initialize();
  
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Master_w::~Master_w() {}

// ----------------------------------------------------------------------------
//  Method : Master_w::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
void Master_w::proc() {
  bool tmp;

  // check if request data channel is free
  tmp = !ipP->getSBusyDataHS();
  if (tmp) {
    if (!req_fifo.empty()){
      // Send data if request group has been already sent
      req_data.MData = req_fifo.peek();
      tmp = ipP->startOCPDataHS(req_data);
      if (tmp) {
	req_fifo.read(); // pop fifo if success

#ifdef DEBUG_G1
      cout << "Master_w sent data "
	   << "  time  = " << sc_time_stamp().to_seconds()
	   << "  MData  = " << req_data.MData << endl;
#endif

      }
    }
  }

  // check if request channel is free
  tmp = !ipP->getSBusy();
  if (tmp || srmd_cont) {
    if (cnt<8) {
      wraplen = 0;
      // Set OCP command type
      req.MCmd = OCP_MCMD_WR;
      req.MReqInfo = protbits;
      req.MBurstSeq = OCP_MBURSTSEQ_INCR;
      req.MAddr = addr;
      req.MBurstLength = 8;
      if (burstcnt==7) {
	req.MReqLast = 1; // End of burst
	burstcnt=0;
      }
      else {
	req.MReqLast = 0;
	burstcnt++;
      }	
    }
    else if (cnt<16) {
      wraplen = 8;
      req.MCmd = OCP_MCMD_WR;
      req.MReqInfo = protbits;
      req.MBurstSeq = OCP_MBURSTSEQ_WRAP;
      req.MAddr = addr;
      req.MBurstLength = 8;
      if (burstcnt==7) {
	req.MReqLast = 1; // End of burst
	burstcnt=0;
      }
      else {
	req.MReqLast = 0;
	burstcnt++;
      }
    }
    else if (cnt<24){
      wraplen = 0;
      req.MCmd = OCP_MCMD_WR;
      req.MReqInfo = protbits;
      req.MBurstSeq = OCP_MBURSTSEQ_STRM;
      req.MAddr = 0;
      req.MBurstLength = 8;
      if (burstcnt==7) {
	req.MReqLast = 1; // End of burst
	burstcnt=0;
      }
      else {
	req.MReqLast = 0;
	burstcnt++;
      }
    }
    else if (cnt<48){ // SRMD burst
      wraplen = 0;
      req.MCmd = OCP_MCMD_WR;
      req.MReqInfo = protbits;
      req.MBurstSeq = OCP_MBURSTSEQ_STRM;
      req.MBurstSingleReq = 1;
      req.MAddr = 0;
      req.MBurstLength = 8;
      req.MReqLast = 1; // End of request burst
      if (burstcnt==7) {
	req_data.MDataLast = 1; // End of data burst
	burstcnt=0;
      }
      else {
	req_data.MDataLast = 0;
	burstcnt++;
      }
    }
    else {
      req.MCmd = OCP_MCMD_IDLE;
    }
  

    // Send request
    if ((req.MBurstSingleReq && burstcnt==1) ||
	!req.MBurstSingleReq) {

      if (req.MBurstSingleReq)
	srmd_cont = true;

      if (req.MCmd != OCP_MCMD_IDLE)
	tmp = ipP->startOCPRequest(req);
      else
	tmp = false;

      if (tmp) {
	req_fifo.write(addr); // This fifo is deeper than slave's
	// Address generator
	if (wraplen) {
	  if ((addr+4) < ((addr & (~(wraplen-1)*4))+ wraplen*4))
	    addr = addr+4; 
	  else
	    addr = addr & (~((wraplen-1)*4));
	}
	else
	  if (addr < 124)
	    addr += 4;
	  else
	    addr = 0;
	cnt++;

#ifdef DEBUG_G1
	cout << "Master_w sent request "
	     << "  time  = " << sc_time_stamp().to_seconds()
	     << "  MAddr  = " << req.MAddr << endl;
#endif

      }
    }
    else if (req.MCmd != OCP_MCMD_IDLE) { // for SRMD data requests
      req_fifo.write(addr++); 
      cnt++;
      if (burstcnt==0)
	srmd_cont = false;
    }
  }


  
  // Check for response
  tmp = ipP->getOCPResponse(resp, true);
  if (tmp) {
    if (resp.SResp == OCP_SRESP_DVA) {

#ifdef DEBUG_G1
      cout << "Master_w got valid response "
	   << "  time  = " << sc_time_stamp().to_seconds()
	   << "  SResp  = " << resp.SResp
	   << "  SData  = " << resp.SData << endl;
#endif

    }
  }
  
} // end of method



