///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :  This file contains a byte enable conversion helper function.
//                 (There is a similar thing in the monitor package, but since
//                 this package is not mandatory, the examples have their own
//                 version of it)
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#ifndef __BYTE_EN_HELPER_H__
#define __BYTE_EN_HELPER_H__

#include "tlm.h"

//TODO: add to OCP namespace
namespace byte_en_helper{
  inline void setBE(unsigned int& ByteEN, tlm::tlm_generic_payload* txn, unsigned int data_width_in_bytes, unsigned int chunk){
    if (txn->get_byte_enable_ptr()){
      ByteEN=0;
      if (tlm::get_host_endianness()==tlm::TLM_BIG_ENDIAN){
        unsigned int mask=0x1<<(data_width_in_bytes-1);
        for (unsigned int i=(data_width_in_bytes*chunk); 
                 i<(data_width_in_bytes*(chunk+1)); 
                 i++){
          if (txn->get_byte_enable_ptr()[i % txn->get_byte_enable_length()]==0xFF)
            ByteEN|=mask;
          mask>>=1;
        }
      }
      else{
        unsigned int mask=0x1;
        for (unsigned int i=(data_width_in_bytes*chunk); 
                 i<(data_width_in_bytes*(chunk+1)); 
                 i++){
          if (txn->get_byte_enable_ptr()[i % txn->get_byte_enable_length()]==0xFF)
            ByteEN|=mask;
          mask<<=1;
        }
      }
    }
    else{
      ByteEN=(unsigned int)-1;
    }
  }
}
#endif

