// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: master.h,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP - TL1 AMBD profile example
//
// ============================================================================

#ifndef _OCP_TL1_MASTER_W_H
#define _OCP_TL1_MASTER_W_H

// Turn on debug messages
#define DEBUG_G1

#include <iostream>
#include "stdlib.h"

// OCP-IP Channel header files
#include "ocpip.h"
#include "fifo.h"

class Master : public sc_core::sc_module
{
  struct outstanding_dhs{
    outstanding_dhs(tlm::tlm_generic_payload* txn_, unsigned int max_chunks_,unsigned int currently_allowed_chunks_, bool srmd_)
      :txn(txn_)
      ,max_chunks(max_chunks_)
      ,currently_allowed_chunks(currently_allowed_chunks_)
      ,srmd(srmd_){}
    tlm::tlm_generic_payload* txn;
    unsigned int max_chunks;
    unsigned int currently_allowed_chunks;
    bool srmd;
  };

  struct expected_rsp{
    expected_rsp(tlm::tlm_generic_payload* txn_, unsigned int chunk_, bool last_)
      : txn(txn_)
      , chunk(chunk_)
      , last(last_){}
    tlm::tlm_generic_payload* txn;
    unsigned int chunk;
    bool last;
  };

public:  
  
  typedef ocpip::ocp_data_class_unsigned<32,32>::DataType Td;
  typedef ocpip::ocp_data_class_unsigned<32,32>::AddrType Ta;

  // channel port
  ocpip::ocp_master_socket_tl1<32> ipP;

  // TL1 clock
  sc_core::sc_in_clk  clk;

  SC_HAS_PROCESS(Master);

  // constructor
  Master(sc_core::sc_module_name name_);

  // destructor
  ~Master();

  // threads
  void proc();
  
  void start_of_simulation();
  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);
  
  unsigned int cnt, burstcnt, dhscnt;
  bool read, writeresps;
  Ta addr;
  bool srmd_cont;

  tlm::tlm_phase phase;
  sc_core::sc_time time;
  
  tlm::tlm_generic_payload* req;
  fifo<outstanding_dhs> req_data;
  fifo<expected_rsp>    expected_rsps;
  
  bool ongoing_req, ongoing_dhs;
  tlm::tlm_generic_payload* resp;
};


#endif // _OCP_TL1_MASTER_W_H
