///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2009-2010
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Herve Alexanian - Sonics, inc.
//
//          $Id:
//
//  Description :  This file defines a generic OCP slave model for use in TL1
//                 modeling examples. Uses TL3 generic slave + TL3/TL1 (master) 
//                 adapter
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#ifndef __OCPIP_GENERIC_MEM_SLAVE_TL1_H__
#define __OCPIP_GENERIC_MEM_SLAVE_TL1_H__

#include "generic_mem_slave_tl3.h"
#include "ocpip_adapters.h"

namespace ocpip_example {
template <unsigned int BUSWIDTH>
class generic_mem_slave_tl1 : public sc_core::sc_module {
public:
    generic_mem_slave_tl1( sc_core::sc_module_name );
    ocpip::ocp_slave_socket_tl1<BUSWIDTH>     m_socket;
    sc_core::sc_in_clk                        m_clk;
private:
    void propagate_config( const ocpip::ocp_parameters&, const std::string& );
    generic_mem_slave_tl3<BUSWIDTH>             m_model;
    ocpip::ocp_tl1_tl3_master_adapter<BUSWIDTH> m_adapter;
};
}

#endif
