// 
//  Copyright 2008 OCP-IP
//  OCP-IP Confidential and Proprietary
// ============================================================================
//      Project : OCP SLD WG
//       Author : Albert Chitemyan Sonics Inc. 
//                
//         $Id: 
//
//  Description : OCP API - Layer-2 Simple Example
//                Top level, synchronous Master <---> synchronous Slave
//
// ============================================================================

// Turn on user messages
//#define DEBUG_TL2

// Include SystemC
#include "systemc"

// Include OCP files
#include "ocpip.h"
// Include user-defined headers
#include "command_line.h"

// Include submodules
#include "master.h"
#include "slave.h"

///////////////////////////////////////////////////////////
// 
// In this example we are going to demonstrate how
// to use word_count payload extension.
// 
// Firstly, master sends 8-length write burst using word count
// extension.
// It sends 3 words in one call and then 5 remaining words in 
// another call.
//  
// Secondly, master sent 4-length read burst.
// Slave sends 3 word response and then remaining 1 word.
//
///////////////////////////////////////////////////////////

int sc_main(int argc, char* argv[]) {

  // OCP parameters
  map_string_type  ocpParamMap;
  std::string ocpParamFileName;

  sc_core::sc_clock clk;

  // Read command line parameters
  process_command_line(argc,argv,ocpParamFileName);

  // Read OCP parameters from file
  if ( ! ocpParamFileName.empty() ) {
    readMapFromFile(ocpParamFileName, ocpParamMap);
  }

  // Submodules
  Slave<32,32> sl1("sl1");
  Master<32,32> ms1("ms1");

  // Set OCP configuration
  ocpip::ocp_parameters params;
  params=create_ocp_configuration_from_map("sl1", ocpParamMap);
  sl1.tp_socket.set_ocp_config(params);

  params=create_ocp_configuration_from_map("ms1", ocpParamMap);
  ms1.ip_socket.set_ocp_config(params);

#ifdef USE_OCP_MONITOR
  ocpip::ocp_connection_monitor<32> ocp_monitor_t_piece(ms1.ip_socket, sl1.tp_socket);
  std::ofstream traceStream;
  traceStream.open( "ocp0.ocptrn" );
  ocpip::ocp_tl2_txn_monitor<32,32> mon (ocp_monitor_t_piece, "txn_mon", traceStream);
#else
  ms1.ip_socket(sl1.tp_socket);
#endif

  ms1.clk(clk);
  sl1.clk(clk);

  // Simulator
  sc_core::sc_start(10, sc_core::SC_NS);

#ifdef USE_OCP_MONITOR
  traceStream.close();
#endif

  return(0);
}
