// 
//  (c) Copyright OCP-IP 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Tim Kogel, CoWare Inc.
//         $Id: 
//
//  Description : declaration of simple OCP TL3 slave,
//
// ============================================================================

#ifndef _OCP_TL3_SLAVE_H
#define _OCP_TL3_SLAVE_H

#include "ocpip.h"

#define DEBUG_TL3_SLAVE
//#define OCP_TL3_SLAVE_USE_PEQ
class ocp_tl3_slave 
  : public sc_core::sc_module
{
public:
  // this module has SC processes
  SC_HAS_PROCESS(ocp_tl3_slave);
  
  // OCP-specific TL3 specialized slave port 
  ocpip::ocp_slave_socket_tl3<> ocp;

  ocp_tl3_slave(sc_core::sc_module_name mod);
  ~ocp_tl3_slave();

private:
  void send_response_method ();

  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload&, tlm::tlm_phase&, sc_core::sc_time&);

  int m_sptr_resp_delay;
  int m_sptr_req_accept;

  std::deque<tlm::tlm_generic_payload*> m_resps;
  int m_req_count_ocp;
  int m_resp_count_ocp;
  sc_core::sc_event m_resp_event;
  sc_core::sc_time  m_one_ns, m_time;
  tlm::tlm_phase m_ph;
};

#endif // _OCP_TL3_SLAVE_H
