// 
//  (c) Copyright OCP-IP 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Tim Kogel, CoWare Inc.
//         $Id: 
//
//  Description : definition of simple OCP TL2 slave,
//		  SCV based randomization of transactions and timing,
//		  implicit delay annotation of OCP_TL3_MasterDelayedIF
//
// ============================================================================

#include "ocp_tl3_slave.h"
using namespace std;
using namespace sc_core;

ocp_tl3_slave::ocp_tl3_slave(sc_core::sc_module_name mod):
  sc_core::sc_module(mod), 
  ocp("ocp"),
  m_req_count_ocp(0),
  m_resp_count_ocp(0)
{
  m_sptr_resp_delay = 10;
  m_sptr_req_accept = 7;
  m_one_ns = sc_core::sc_time(1, sc_core::SC_NS);


  ocp.register_nb_transport_fw(this, &ocp_tl3_slave::nb_transport
#ifdef OCP_TL3_SLAVE_USE_PEQ
                              , true
#endif
                              );

  SC_METHOD(send_response_method);
  sensitive << m_resp_event;
  dont_initialize();
}

ocp_tl3_slave::~ocp_tl3_slave()
{
  std::cout << sc_core::sc_module::name() << ", received : " << m_req_count_ocp 
       << ", sent : " << m_resp_count_ocp << std::endl;
}

void
ocp_tl3_slave::send_response_method(){
  assert(m_resps.size());
  m_ph=tlm::BEGIN_RESP;
  m_time=sc_core::SC_ZERO_TIME;
  m_resp_count_ocp++;
  m_resps.front()->set_response_status(tlm::TLM_OK_RESPONSE);
  m_resps.front()->acquire(); //make sure the txn survives a release by the master within nb_transport_bw
  switch(ocp->nb_transport_bw(*m_resps.front(), m_ph, m_time)){  
    case tlm::TLM_ACCEPTED: break;
    case tlm::TLM_UPDATED:
      if (m_ph!=tlm::END_RESP) break; //ignorable phase
    case tlm::TLM_COMPLETED:
      m_resps.front()->release(); 
      m_resps.pop_front();
      
  }
  
}

tlm::tlm_sync_enum ocp_tl3_slave::nb_transport(tlm::tlm_generic_payload& gp, tlm::tlm_phase& ph, sc_core::sc_time& t){
  switch(ph){
    case tlm::BEGIN_REQ:
      m_sptr_req_accept = 5+ (m_sptr_req_accept+1)%8;
      m_sptr_resp_delay = 5+ (m_sptr_req_accept+1)%10;
  
      m_req_count_ocp++;
      #ifdef DEBUG_TL3_SLAVE 
      std::cout << sc_core::sc_time_stamp()+t << " slave " << sc_core::sc_module::name() 
           << " got request :" << std::endl 
           << ((gp.is_write())?"Write":"Read")<<" Request : address"<<((gp.is_write())?",data":"")<<" = ";
      if (gp.is_write())
        std::cout<<" "<<gp.get_address()<<" , "<<*((unsigned int*)gp.get_data_ptr())<<std::endl<<std::endl;
      else
        std::cout<<gp.get_address()<<std::endl<<std::endl;
      #endif


      switch(gp.get_command()){
        case tlm::TLM_READ_COMMAND:
          m_time=m_one_ns*m_sptr_resp_delay;
          #ifdef DEBUG_TL3_SLAVE 
              std::cout << sc_core::sc_time_stamp()+t << " slave " << sc_core::sc_module::name() 
               << " send response in " << m_sptr_resp_delay
               << " cycles\n";
          #endif
          t+=m_time;
          
          m_resp_event.notify(t);
          m_resps.push_back(&gp);
          return tlm::TLM_ACCEPTED;
        case tlm::TLM_WRITE_COMMAND:
          assert(ocp.get_extension<ocpip::posted>(gp)); //we do not support nonposted writes        
          m_time=m_one_ns*m_sptr_req_accept;
          t+=m_time;
#ifdef OCP_TL3_SLAVE_USE_PEQ
          m_resp_event.notify(t);
          m_resps.push_back(&gp); //we schedule the BEGIN_RESP
                                  //to the time of the SCmdAccept, because in reality we do not have a resp (writeresp=false)
                                  //so we use the BEGIN_RESP-swallows-END_REQ feature to end the txn with SCmdAccept from our point of view.
#else     
          gp.set_response_status(tlm::TLM_OK_RESPONSE);
          m_resp_count_ocp++;
          return tlm::TLM_COMPLETED;
#endif
        default: ;
      }
      break;
    case tlm::END_RESP:
      assert(m_resps.size());
      m_resps.front()->release(); 
      m_resps.pop_front();
      break;
    default: ;
  }
  return tlm::TLM_ACCEPTED;
}

