///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2009-2010
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Herve Alexanian - Sonics, inc.
//
//          $Id:
//
//  Description :  This file defines a generic OCP slave model for use in TL3
//                 modeling examples
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#include "generic_mem_slave_tl3.h"

template<unsigned int BUSWIDTH>
ocpip_example::generic_mem_slave_tl3<BUSWIDTH>::generic_mem_slave_tl3( sc_core::sc_module_name nm ) :
    sc_core::sc_module( nm )
    , m_socket( "socket", ocpip::ocp_tl3 )
{
    m_socket.register_nb_transport_fw(this, &generic_mem_slave_tl3::nb_transport);
}

template<unsigned int BUSWIDTH>
tlm::tlm_sync_enum
ocpip_example::generic_mem_slave_tl3<BUSWIDTH>::nb_transport(
    tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim)
{
    assert(ph==tlm::BEGIN_REQ);
    tim=sc_core::sc_time(2, sc_core::SC_NS);
    ph=tlm::BEGIN_RESP;
    if ( txn.is_write() )
	m_memory.write( txn.get_address(), txn.get_data_ptr(), txn.get_data_length() );
    if ( txn.is_read() )
	m_memory.read( txn.get_address(), txn.get_data_ptr(), txn.get_data_length() );
    return tlm::TLM_UPDATED;
}


template <typename addr_t, typename data_t>
ocpip_example::simple_sparse_memory<addr_t, data_t>::simple_sparse_memory( const data_t& default_value ) :
    m_default_value( default_value )
{}

template <typename addr_t, typename data_t>
void
ocpip_example::simple_sparse_memory<addr_t, data_t>::write( addr_t addr, const data_t& data )
{
    m_memory.insert( std::make_pair( addr, data ) );
}
template <typename addr_t, typename data_t>
void
ocpip_example::simple_sparse_memory<addr_t, data_t>::write( addr_t addr, data_t* data, uint32_t length )
{
    for ( uint32_t i=0; i<length; ++i )
	m_memory.insert( std::make_pair( addr++, *(data+i) ) );
}

template <typename addr_t, typename data_t>
void
ocpip_example::simple_sparse_memory<addr_t, data_t>::read( addr_t addr, data_t& data ) const
{
    data = m_default_value;
    typename std::map<addr_t, data_t>::const_iterator found = m_memory.find( addr );    
    if ( found != m_memory.end() ) {
	data = found->second;
    }
}

template <typename addr_t, typename data_t>
void
ocpip_example::simple_sparse_memory<addr_t, data_t>::read( addr_t addr, data_t* data, uint32_t length ) const
{
    for ( uint32_t i=0; i<length; ++i )
	read( addr++, *( data + i ) );
}

template <typename addr_t, typename data_t>
void
ocpip_example::simple_sparse_memory<addr_t, data_t>::reset()
{
    m_memory.clear();
}

template class ocpip_example::simple_sparse_memory<uint64_t,unsigned char>;
