///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2009-2010
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Herve Alexanian - Sonics, inc.
//
//          $Id:
//
//  Description :  This file defines a generic OCP master model driven by STL
//                 stimulus for use in TL3 modeling examples
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#ifndef __OCPIP_GENERIC_STL_MASTER_TL3_H__
#define __OCPIP_GENERIC_STL_MASTER_TL3_H__

#include <iostream>
#include "stdlib.h"
#include "ocpip.h"
#include "IStl.h"

namespace ocpip_example {
template <unsigned int BUSWIDTH>
class generic_stl_master_tl3 : public sc_core::sc_module
{
public:
  generic_stl_master_tl3(sc_core::sc_module_name name_);
  ~generic_stl_master_tl3();

  ocpip::ocp_master_socket<BUSWIDTH>  m_socket;
  sc_core::sc_time                    m_period;
  void set_period( sc_core::sc_time t ) {
      m_period = t;
  }
  static const uint32_t s_byte_width = (BUSWIDTH+7 >> 3);

protected:
  struct StlStream : public sc_core::sc_module {
      SC_HAS_PROCESS(StlStream);
      StlStream( sc_core::sc_module_name, generic_stl_master_tl3& );
      void proc();
      generic_stl_master_tl3& master;
      ocpip_legacy::OcpIp::IStlReader* pStl;
  };
  std::vector<StlStream*> m_streams;

  virtual void before_end_of_elaboration();
  virtual void when_config_known( const ocpip::ocp_parameters&, const std::string& );

private:
  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload&, tlm::tlm_phase&, sc_core::sc_time&);
};
}

#endif
