///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2009-2010
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Herve Alexanian - Sonics, inc.
//
//          $Id:
//
//  Description :  This file defines a layer adapter module for TL1 sockets.
//                 Designed to play incoming OCP TLM transactions at the TL1
//                 level with certain user controls.
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef OCPIP_VERSION
  #error ocp_tl1_tl3_slave_adapter.h may not be included directly. Use #include "ocpip.h" or #include "ocpip_X_X_X.h" (where desired ocp version is X.X.X)
#endif

namespace OCPIP_VERSION {
template <unsigned int BUSWIDTH> class ocp_tl1_tl3_slave_adapter : public sc_core::sc_module
{
private:
    // define before socket
    ocp_tl1_master_timing_guard                      m_timing_guard;
public:
    sc_core::sc_in_clk                               clk;
    ocp_slave_socket     <BUSWIDTH>                  slave_socket;
    ocp_master_socket_tl1<BUSWIDTH>                  tl1_socket;

    SC_HAS_PROCESS(ocp_tl1_tl3_slave_adapter);
    ocp_tl1_tl3_slave_adapter(sc_core::sc_module_name name_, ocp_layer_ids layer=ocp_tl3 );
    ~ocp_tl1_tl3_slave_adapter();

    void reset();

    // phase delay policy
    template <typename delay_calc_t>
    void set_delay_obj( tlm::tlm_phase ph, delay_calc_t obj ) {
	if ( ph == tlm::BEGIN_REQ )
	    m_p_req_delay_calc = new delay_calc_t( obj );
	else if ( ph == BEGIN_DATA )
	    m_p_data_delay_calc = new delay_calc_t( obj );
	else if ( ph == tlm::END_RESP )
	    m_p_resp_acc_delay_calc = new delay_calc_t( obj );
	else {
	    assert( false && "Delay phase must be BEGIN_REQ or BEGIN_DATA" );
	}
    }

private:
    virtual void before_end_of_elaboration();
    //virtual void ocp_config_known( const ocp_parameters&, const std::string& );

    // higher layer tansport
    tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload&, tlm::tlm_phase&, sc_core::sc_time&);

    // transaction bookkeeping
    tlm_utils::instance_specific_extension_accessor acc;
    ocp_extension_pool<ocp_txn_burst_invariant>    m_invariant_ext_pool;
    ocp_extension_pool<ocp_txn_position>           m_position_ext_pool;
    std::vector<std::vector<ocp_txn_track> >       m_burst_tracker;

    typedef size_t thread_type;
    typedef simple_phase_queue<ocp_tl1_phase_pos>  phase_queue;

    // request arbitration
    static const thread_type s_no_winner = static_cast<thread_type>( -1 );
    std::vector<phase_queue*>                      m_req_txn;
    simple_arb<thread_type, simple_rr_arb_algo>    m_req_arb;
    arbiter_threadbusy_filter<thread_type>         m_sthreadbusy_filt;
    sc_core::sc_event                              m_new_req_input_ev;
    sc_core::sc_event                              m_cmd_accept_ev;
    void        request_arb_th();
    void        wait_sthreadbusy_stable();
    bool        send_request( thread_type );
    std::vector<phase_queue*>                      m_data_waiting_txn;

    // data arbitration
    std::vector<phase_queue*>                      m_data_txn;
    simple_arb<thread_type, simple_rr_arb_algo>    m_data_arb;
    arbiter_threadbusy_filter<thread_type>         m_sdatathreadbusy_filt;
    sc_core::sc_event                              m_new_data_input_ev;
    sc_core::sc_event                              m_data_accept_ev;
    thread_type                                    m_force_data_together_thread;
    void        data_arb_th();
    void        wait_sdatathreadbusy_stable();
    bool        send_data( thread_type );

    // response acceptance
    typedef phase_delayed_accept<ocp_tl1_tl3_slave_adapter, uint32_t, ocp_tl1_phase_pos> delayed_accept;
    delayed_accept    m_resp_accept;
    ocp_tl1_phase_pos m_resp_pending_acc;
    void accept_resp ( ocp_tl1_phase_pos& );

    // phase delays
    void phase_delay_peq_out(); // SC_METHOD to exploit the mature PEQ items
    phase_delay_calc_if<uint32_t>*                 m_p_req_delay_calc;
    phase_delay_calc_if<uint32_t>*                 m_p_data_delay_calc;
    phase_delay_calc_if<uint32_t>*                 m_p_resp_acc_delay_calc;
    ocp_cycle_based_peq<int>                       m_phase_delay_peq; // shared among threads/phases
    
    // TL1 timing propagation
    void update_timing();
    void set_tl1_slave_timing( ocp_tl1_slave_timing );
    sc_core::sc_time                               m_send_req_time;
    sc_core::sc_time                               m_send_data_time;
    ocp_tl1_master_timing                          m_my_tl1_timing;

    // threadbusy
    uint32_t m_cur_sthreadbusy, m_cur_sdatathreadbusy;
    uint32_t m_pipelined_sthreadbusy, m_pipelined_sdatathreadbusy;
    void pipeline_threadbusy_signals();

    // tl1 socket
    ocp_parameters ocp_params;
    tlm::tlm_sync_enum nb_transport_tl1(tlm::tlm_generic_payload&, tlm::tlm_phase&, sc_core::sc_time&);
    void handle_end_phase(tlm::tlm_generic_payload&, tlm::tlm_phase&);
    tlm::tlm_phase phase;
    sc_core::sc_time time;
    tlm::tlm_generic_payload* m_req_issued;
    tlm::tlm_generic_payload* m_data_issued;

    static const uint32_t s_byte_width = (BUSWIDTH+7 >> 3);
    static const uint32_t s_interleave_size = 4;
};
}

#include __MACRO_STRINGYFY__(../src/OCPIP_VERSION/ocp_tl1_tl3_slave_adapter.tpp)
