///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :  
//                 This file contains a byte enable conversion helper function.
//                 It will be moved into a namespace later on.
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef OCPIP_VERSION
  #error ocp_monitor_helpers.h may not be included directly. Use #inculde "ocpip.h" or #include "ocpip_X_X_X.h" (where desired ocp version is X.X.X)
#endif

namespace OCPIP_VERSION{

//struct ocp_monitor_helpers{
//  static inline void setBE(unsigned int& ByteEN, tlm::tlm_generic_payload* txn, unsigned int data_width_in_bytes, unsigned int chunk);
//};
class ocp_connection_monitor_timing_attachment{
public:
  template <unsigned int BUSWIDTH, unsigned int M, unsigned int N, typename M_SOCKET_BASE, typename N_SOCKET_BASE>
  ocp_connection_monitor_timing_attachment(ocp_master_socket<BUSWIDTH,M,M_SOCKET_BASE>& msock, ocp_slave_socket<BUSWIDTH,N,N_SOCKET_BASE>& ssock)
  {
    m_mtime_cb=ssock.m_time_cb;
    m_stime_cb=msock.m_time_cb;    
    ssock.m_time_cb.set_function(this, &ocp_connection_monitor_timing_attachment::set_master_timing);
    msock.m_time_cb.set_function(this, &ocp_connection_monitor_timing_attachment::set_slave_timing);
  }
  
  void set_master_timing(ocp_tl1_master_timing timing){
    m_mtiming=timing;
    if (!m_mtime_cb.empty()) m_mtime_cb(timing);
  }

  void set_slave_timing(ocp_tl1_slave_timing timing){
    m_stiming=timing;
    if (!m_stime_cb.empty()) m_stime_cb(timing);
  }
  
  const ocp_tl1_master_timing& get_mtiming(){return m_mtiming;}
  const ocp_tl1_slave_timing&  get_stiming(){return m_stiming;}
  

protected:
  set_master_timing_callback_functor<tlm::tlm_base_protocol_types> m_mtime_cb;
  set_slave_timing_callback_functor<tlm::tlm_base_protocol_types>  m_stime_cb;
  ocp_tl1_master_timing m_mtiming;
  ocp_tl1_slave_timing  m_stiming;
};

template <unsigned int BUSWIDTH>
class ocp_connection_monitor: public OCPIP_VERSION::infr::monitor<BUSWIDTH, tlm::tlm_base_protocol_types>
                            , public ocp_connection_monitor_timing_attachment
{
public:
  template <unsigned int M, unsigned int N, typename M_SOCKET_BASE, typename N_SOCKET_BASE>
  ocp_connection_monitor(ocp_master_socket<BUSWIDTH,M,M_SOCKET_BASE>& msock, ocp_slave_socket<BUSWIDTH,N,N_SOCKET_BASE>& ssock)
    : OCPIP_VERSION::infr::monitor<BUSWIDTH, tlm::tlm_base_protocol_types>(
        sc_core::sc_gen_unique_name("ocp_socket_connection_monitor")
      , msock.name()
      , ssock.name())
    , ocp_connection_monitor_timing_attachment(msock,ssock)
  {
    msock(this->t_socket);
    this->i_socket(ssock);
  }

};


}
#include __MACRO_STRINGYFY__(../mon/src/OCPIP_VERSION/ocp_monitor_helpers.hpp)
