// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                (modified by Joe Chou, Sonics Inc., joechou@sonicsinc.com
//      		  Yann Bajot, PROSILOG, bajot@prosilog.com 
//                Stephane Guntz, PROSILOG, guntz@prosilog.com)
//
//  Description : Transaction Level - Layer-2 Slave example.
//  $Id: ocp_tl2_slave.h,v 1.1.1.1 2004/09/24 09:26:20 sguntz Exp $
//
// ============================================================================



#ifndef _OCP_TL2_SLAVE_H
#define _OCP_TL2_SLAVE_H

#include "systemc.h"
#include "ocp_globals.h"
#include "ocp_param.h"
#include "ocp_tl2_slave_port.h"

const sc_time_unit TL_TIME_UNIT  = SC_NS; 
const double       TL_CLK_PERIOD = 10;     // clock period
const double TL_TIME_SCALE_SEC   = 0.000000001;
const sc_time_unit TL_TIME_SCALE = SC_NS;       // clock period
#define TL_SLAVE_TL2_FIFO_DEPTH 8

class OCP_TL2_Slave
  : public sc_module
{
public:

  //
  typedef int Td;
  typedef int Ta;

  OCP_TL2_SlavePort< Td, Ta > SlaveP;

  //
  SC_HAS_PROCESS(OCP_TL2_Slave);

  // constructor
  OCP_TL2_Slave(sc_module_name name_, int ID, Ta StartAddress, Ta EndAddress,
    bool Pipelined = false, bool WriteResponse = true,
    int ReadAcceptCycles = 0, int WriteAcceptCycles = 0,
    int ReadResponseCycles = 0, int WriteResponseCycles = 0);

  // destructor
  ~OCP_TL2_Slave();

  // methods
  bool MputDirect(int, bool, Td*, Ta, int);

  //
  void PrintTrans(int TaNum, Ta Addr, int NumWords, const char* Method);
  void PrintTime(const char* Pstring, int ID, Ta Addr);
  void PrintFuTime(const char* Pstring, int ID, Ta Addr, double AddTime);
  void Slave();
  void SlaveRequest();
  void SlaveResponse();

private:

  //
  void end_of_elaboration();

  // Pointer to the parameter class
  OCPParameters *m_ParamCl;

  // Slave parameters
  int  m_ID;
  Ta   m_StartAddress;
  Ta   m_EndAddress;
  bool m_Pipelined;
  bool m_WriteResponse;
  int  m_ReadAcceptCycles;
  int  m_WriteAcceptCycles;
  int  m_ReadResponseCycles;
  int  m_WriteResponseCycles;

  //
  int m_BusID;

  // Data arrays
  Td* m_SlaveMemory;

  // Constants
  int m_SmemoryLength;

  //
  bool last_chunk[TL_SLAVE_TL2_FIFO_DEPTH];
  Td*  m_Mdata[TL_SLAVE_TL2_FIFO_DEPTH];
  unsigned int  m_NumWords[TL_SLAVE_TL2_FIFO_DEPTH];
  unsigned int  m_NumBytesPerWord;
  Ta   m_Address[TL_SLAVE_TL2_FIFO_DEPTH];
  bool m_Write[TL_SLAVE_TL2_FIFO_DEPTH];
  int  m_MconnID[TL_SLAVE_TL2_FIFO_DEPTH];
  int  m_MthreadID[TL_SLAVE_TL2_FIFO_DEPTH];

  // Slave response
  OCPSRespType m_Sresp[TL_SLAVE_TL2_FIFO_DEPTH];

  // Request and response transaction numbers
  int m_ReqTaNum;
  int m_ResTaNum;

  // -------------------------
  // modelling pipelined delay
  // -------------------------
  // State to catch missed events
  bool     m_SlaveRespWait[TL_SLAVE_TL2_FIFO_DEPTH];

  //
  sc_time  m_RespStartTime[TL_SLAVE_TL2_FIFO_DEPTH];
  sc_event m_SlaveRespEvent;
};

#endif // _OCP_TL2_SLAVE_H
