// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: master.h,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP - TL1 profile example
//
// ============================================================================

#ifndef _OCP_TL1_MASTER_SYNC_H
#define _OCP_TL1_MASTER_SYNC_H

// Turn on debug messages
//#define DEBUG_G1

#include <iostream>
#include "stdlib.h"
#include <deque>

// OCP-IP Channel header files
#include "ocpip.h"
#include "fifo.h"


class Master : public sc_core::sc_module
{
  struct expected_rsp{
    expected_rsp(tlm::tlm_generic_payload* txn_, unsigned int chunk_, bool last_)
      : txn(txn_)
      , chunk(chunk_)
      , last(last_){}
    tlm::tlm_generic_payload* txn;
    unsigned int chunk;
    bool last;
  };
  
  struct my_lock_object: public ocpip::lock_object_base
  {
  private:
    friend class ocpip::ocp_extension_pool<my_lock_object>;
  
    void atomic_txn_completed(){
      get_pool()->recycle(this);
    }

    my_lock_object(){
      ocpip::lock_object_base::number_of_txns=2;
    }

  public:    
    static ocpip::ocp_extension_pool<my_lock_object>* get_pool(){
      static ocpip::ocp_extension_pool<my_lock_object> s_pool(5);
      return &s_pool;
    }
  };

public:  
  
  typedef ocpip::ocp_data_class_unsigned<32,32>::DataType Td;
  typedef ocpip::ocp_data_class_unsigned<32,32>::AddrType Ta;

  // channel port
  //OCP_TL1_MasterPort<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > ipP;
  ocpip::ocp_master_socket_tl1<32> ipP;

  // TL1 clock
  sc_core::sc_in_clk  clk;

  SC_HAS_PROCESS(Master);

  // constructor
  Master(sc_core::sc_module_name name_);

  // destructor
  ~Master();

  // threads
  void proc();

  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);

  bool read;
  int cnt, burstcnt;
  int wraplen;
  Ta addr;

  fifo<expected_rsp> expected_rsps;

  // Response group
  tlm::tlm_generic_payload* req;
  std::deque<tlm::tlm_generic_payload*> check_locks;
  my_lock_object* current_lock;
  bool ongoing_req;
  tlm::tlm_generic_payload* resp;
  sc_core::sc_time time;
  tlm::tlm_phase phase;
  Td localData;
};


#endif // _OCP_TL1_MASTER_SYNC_H
