// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Albert Chitemyan, Sonics Inc. 
//              
//         $Id: 
//
//  Description : OCP - TL2 example Slave
//
// ============================================================================

#ifndef _OCP_TL2_SLAVE_SYNC_H
#define _OCP_TL2_SLAVE_SYNC_H

#define DEBUG_TL2

#include <iostream>

// OCP-IP Channel header files
#include "ocpip.h"

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH>
class Slave : public sc_core::sc_module {
public:  

  typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH,ADDRWIDTH>::DataType Td;
  typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH,ADDRWIDTH>::AddrType Ta;

  ocpip::ocp_slave_socket_tl2<32> tp_socket;

  sc_core::sc_in_clk clk;

  SC_HAS_PROCESS(Slave);

  // constructor
  Slave(sc_core::sc_module_name name_);

  // destructor
  ~Slave();

  // Threads
  void proc();

  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);

  // utility function 
  void generate_read_response();

  // OCP request group
  tlm::tlm_generic_payload* req;
  bool ongoing_rsp;
  tlm::tlm_generic_payload* rsp;
  tlm::tlm_phase            phase;
  sc_core::sc_time          time;
  tlm::tlm_command last_request;

  // response word count related variables
  ocpip::word_count* word_count_info;
  unsigned int       chunk_counter;
  unsigned int       sent_word_cnt;

  unsigned int get_burst_length();
  unsigned int burst_length;
  unsigned int response_data[4];

};

#endif
