///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :  A class that contains all the ocp parameters and shall
//                 be used to configure an ocp socket
//
//                 Basically there are two classes. One for socket internal
//                 use only (ocp_parameters_configurable) that enables to use
//                 external configuration tools to configure sockets.
//
//                 The other one (ocp_parameters) shall be used by users.
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


#ifndef OCPIP_VERSION
  #error ocp_parameters.h may not be included directly. Use #inculde "ocpip.h" or #include "ocpip_X_X_X.h" (where desired ocp version is X.X.X)
#endif


#include <string>
#include <sstream>
#include <iostream>
#include <map>

/*
In case you don't like the ocp_params, define 
USE_EXTERNAL_PARAM_TYPE using a compiler switch

Example:
  g++ -DUSE_EXTERNAL_PARAM_TYPE=foo_param.h

This will include foo_param.h instead of defining the ocp_param struct
So foo_param.h could be like this

<file foo_param.h>
#include "my_super_dooper_foo_param_framework.h"
#define ocp_param foo_param
<end file foo_param.h>

This will of course only work, if the foo_param is
of form

template<typename T>
struct foo_param";

It has to behave just like a T on its boundary.

-DUSE_EXTERNAL_PARAM_TYPE=use_gs_param.h
*/

#ifndef USE_EXTERNAL_PARAM_TYPE
//a simple class wrapper for POD types

namespace OCPIP_VERSION{

template<typename T>
struct ocp_param{
  ocp_param(const std::string&, T init): value(init){}

  operator T&(){return value;}
  operator const T&() const{return value;}
  //operator const T()const {return value;}
  T& operator=(const T& other){value=other; return value;}
  private :
    T value;
};

}

#else
#define __INCLEND__ h
#include __MACRO_STRINGYFY__(USE_EXTERNAL_PARAM_TYPE.__INCLEND__)
#undef __INCLEND__
#endif
namespace OCPIP_VERSION{

enum ocp_layer_ids{
  ocp_tl1=0x1,
  ocp_tl2=0x2,
  ocp_tl3=0x4,
  ocp_tl4=0x8
};

enum ocp_config_state_enum {ocp_unconfigured=0, ocp_generic=1, ocp_configured=2};

class ocp_parameters;

class ocp_parameters_configurable{
public:


  inline ocp_parameters_configurable(const std::string& owner_name="No name provided");
  
  inline ocp_parameters_configurable& operator=(const ocp_parameters&);
  
  inline ocp_parameters get_params() const;
  
  ocp_param<float> ocp_version;
  ocp_param<std::string> name; 
  ocp_param<bool> broadcast_enable;
  ocp_param<bool> burst_aligned;
  ocp_param<bool> burstseq_dflt1_enable;
  ocp_param<bool> burstseq_dflt2_enable;
  ocp_param<bool> burstseq_incr_enable;
  ocp_param<bool> burstseq_strm_enable;
  ocp_param<bool> burstseq_unkn_enable;
  ocp_param<bool> burstseq_wrap_enable;
  ocp_param<bool> burstseq_xor_enable;
  ocp_param<bool> burstseq_blck_enable;
  ocp_param<int> endian;
  ocp_param<bool> force_aligned;
  ocp_param<bool> mthreadbusy_exact;
  ocp_param<bool> rdlwrc_enable;
  ocp_param<bool> read_enable;
  ocp_param<bool> readex_enable;
  ocp_param<bool> sdatathreadbusy_exact;
  ocp_param<bool> sthreadbusy_exact;
  ocp_param<bool> write_enable;
  ocp_param<bool> writenonpost_enable;
  ocp_param<bool> datahandshake;
  ocp_param<bool> reqdata_together;
  ocp_param<bool> writeresp_enable;
  ocp_param<bool> addr;
  ocp_param<int> addr_wdth;
  ocp_param<bool> addrspace;
  ocp_param<int> addrspace_wdth;
  ocp_param<bool> atomiclength;
  ocp_param<int> atomiclength_wdth;
  ocp_param<bool> burstlength;
  ocp_param<int> burstlength_wdth;
  ocp_param<bool> blockheight;
  ocp_param<int> blockheight_wdth;
  ocp_param<bool> blockstride;
  ocp_param<int> blockstride_wdth;
  ocp_param<bool> burstprecise;
  ocp_param<bool> burstseq;
  ocp_param<bool> burstsinglereq;
  ocp_param<bool> byteen;
  ocp_param<bool> cmdaccept;
  ocp_param<bool> connid;
  ocp_param<int> connid_wdth;
  ocp_param<bool> dataaccept;
  ocp_param<bool> datalast;
  ocp_param<bool> datarowlast;
  ocp_param<int> data_wdth;
  ocp_param<bool> mdata;
  ocp_param<bool> mdatabyteen;
  ocp_param<bool> mdatainfo;
  ocp_param<int> mdatainfo_wdth;
  ocp_param<int> mdatainfobyte_wdth;
  ocp_param<bool> sdatathreadbusy;
  ocp_param<bool> mthreadbusy;
  ocp_param<bool> reqinfo;
  ocp_param<int> reqinfo_wdth;
  ocp_param<bool> reqlast;
  ocp_param<bool> reqrowlast;
  ocp_param<bool> resp;
  ocp_param<bool> respaccept;
  ocp_param<bool> respinfo;
  ocp_param<int> respinfo_wdth;
  ocp_param<bool> resplast;
  ocp_param<bool> resprowlast;
  ocp_param<bool> sdata;
  ocp_param<bool> sdatainfo;
  ocp_param<int> sdatainfo_wdth;
  ocp_param<int> sdatainfobyte_wdth;
  ocp_param<bool> sthreadbusy;
  ocp_param<int> threads;
  ocp_param<int> tags;
  ocp_param<bool> taginorder;
  ocp_param<bool> control;
  ocp_param<bool> controlbusy;
  ocp_param<int> control_wdth;
  ocp_param<bool> controlwr;
  ocp_param<bool> interrupt;
  ocp_param<bool> merror;
  ocp_param<bool> mflag;
  ocp_param<int> mflag_wdth;
  ocp_param<bool> mreset;
  ocp_param<bool> serror;
  ocp_param<bool> sflag;
  ocp_param<int> sflag_wdth;
  ocp_param<bool> sreset;
  ocp_param<bool> status;
  ocp_param<bool> statusbusy;
  ocp_param<bool> statusrd;
  ocp_param<int> status_wdth;
  ocp_param<bool> sthreadbusy_pipelined;
  ocp_param<bool> mthreadbusy_pipelined;
  ocp_param<bool> sdatathreadbusy_pipelined;
  ocp_param<int> config_state;
};


typedef std::map<std::string, std::string> map_string_type;

class ocp_parameters
{
public:

  // Constructor
  inline ocp_parameters();
  // The parameter myParamValue is set only if the parameter is found in the 
  // configuration map and if it is of type 'i' for integer.
  static inline bool 
  getBoolOCPConfigValue(
    const std::string& myPrefix, 
    const std::string& myParamName, 
    bool &myParamValue, 
    map_string_type& Map, 
    std::string my_name="");

  // The parameter myParamValue is set only if the parameter is found in the 
  // configuration map and if it is of type 'i' for integer.
  static inline bool 
  getIntOCPConfigValue(
    const std::string& myPrefix, 
    const std::string& myParamName, 
    int &myParamValue, 
    map_string_type& Map, 
    std::string my_name="");
    
  // The parameter myParamValue is set only if the parameter is found in the 
  // configuration map and if it is of type 's' for std::string.
  static inline bool 
  getStringOCPConfigValue(
    const std::string& myPrefix, 
    const std::string& myParamName, 
    std::string& myParamValue, 
    map_string_type& Map, 
    std::string my_name="");

  template<typename DataCl>
  ocpip_legacy::ParamCl<DataCl> legacy_conversion() const;

  inline void 
  set_ocp_configuration(std::string ocp_name, map_string_type& passedMap);

  //this functions extracts the used TLM2 extensions and phases
  // out of the ocp paramters set
  template<typename BIND_BASE>
  typename BIND_BASE::config_type convert_to_base_socket_config(bool mNs, ocp_layer_ids layer);
    
  //only used, if the an ocp socket is connected to a non ocp socket
  //TODO: make it fit to the new has_extension and has_phase signatures
  template<typename BIND_BASE>
  void init_from_base_socket_config(const typename BIND_BASE::config_type& conf, unsigned int data_width);
  
  //this function initializes an ocp parameters set so that it is OSCI compliant
  //the argument data_width will be used to configure the data_wdth parameter of
  //ocp
  inline void init_as_osci_config(unsigned int data_width);

  //this function dumps the whole parameter set to standard out
  inline std::string to_string ()const;
  
  //this function compares ocp parameter set provided as the function argument to
  // the ocp parameters set on which the function is called
  // It returns true if there is a difference
  inline bool diff(const ocp_parameters& other);
  
  inline ocp_parameters& operator=(const ocp_parameters&);
  
  // OCP parameters
  float ocp_version;
  std::string name; 
  bool broadcast_enable;
  bool burst_aligned;
  bool burstseq_dflt1_enable;
  bool burstseq_dflt2_enable;
  bool burstseq_incr_enable;
  bool burstseq_strm_enable;
  bool burstseq_unkn_enable;
  bool burstseq_wrap_enable;
  bool burstseq_xor_enable;
  bool burstseq_blck_enable;
  int endian;
  bool force_aligned;
  bool mthreadbusy_exact;
  bool rdlwrc_enable;
  bool read_enable;
  bool readex_enable;
  bool sdatathreadbusy_exact;
  bool sthreadbusy_exact;
  bool write_enable;
  bool writenonpost_enable;
  bool datahandshake;
  bool reqdata_together;
  bool writeresp_enable;
  bool addr;
  int addr_wdth;
  bool addrspace;
  int addrspace_wdth;
  bool atomiclength;
  int atomiclength_wdth;
  bool burstlength;
  int burstlength_wdth;
  bool blockheight;
  int blockheight_wdth;
  bool blockstride;
  int blockstride_wdth;
  bool burstprecise;
  bool burstseq;
  bool burstsinglereq;
  bool byteen;
  bool cmdaccept;
  bool connid;
  int connid_wdth;
  bool dataaccept;
  bool datalast;
  bool datarowlast;
  int data_wdth;
  bool mdata;
  bool mdatabyteen;
  bool mdatainfo;
  int mdatainfo_wdth;
  int mdatainfobyte_wdth;
  bool sdatathreadbusy;
  bool mthreadbusy;
  bool reqinfo;
  int reqinfo_wdth;
  bool reqlast;
  bool reqrowlast;
  bool resp;
  bool respaccept;
  bool respinfo;
  int respinfo_wdth;
  bool resplast;
  bool resprowlast;
  bool sdata;
  bool sdatainfo;
  int sdatainfo_wdth;
  int sdatainfobyte_wdth;
  bool sthreadbusy;
  int threads;
  int tags;
  bool taginorder;
  bool control;
  bool controlbusy;
  int control_wdth;
  bool controlwr;
  bool interrupt;
  bool merror;
  bool mflag;
  int mflag_wdth;
  bool mreset;
  bool serror;
  bool sflag;
  int sflag_wdth;
  bool sreset;
  bool status;
  bool statusbusy;
  bool statusrd;
  int status_wdth;
  bool sthreadbusy_pipelined;
  bool mthreadbusy_pipelined;
  bool sdatathreadbusy_pipelined;
  int config_state;
};

} //end ns OCPIP_VERSION

#include __MACRO_STRINGYFY__(../src/OCPIP_VERSION/ocp_parameters_configurable.tpp)

#include __MACRO_STRINGYFY__(../src/OCPIP_VERSION/ocp_parameters.tpp)
/*

//Copy and paste the code in this comment section to
// set up a configuration that covers all possible
// parameters

map_string_type config_map";

config_map["broadcast_enable"]="i:0";
config_map["burst_aligned"]="i:0";
config_map["burstseq_dflt1_enable"]="i:0";
config_map["burstseq_dflt2_enable"]="i:0";
config_map["burstseq_incr_enable"]="i:0";
config_map["burstseq_strm_enable"]="i:0";
config_map["burstseq_unkn_enable"]="i:0";
config_map["burstseq_wrap_enable"]="i:0";
config_map["burstseq_xor_enable"]="i:0";
config_map["burstseq_blck_enable"]="i:0";
config_map["endian"]="i:1";
config_map["force_aligned"]="i:0";
config_map["mthreadbusy_exact"]="i:0";
config_map["rdlwrc_enable"]="i:0";            
config_map["read_enable"]="i:1";
config_map["readex_enable"]="i:0";
config_map["sdatathreadbusy_exact"]="i:0";
config_map["sthreadbusy_exact"]="i:0";
config_map["write_enable"]="i:1";
config_map["writenonpost_enable"]="i:0";
config_map["datahandshake"]="i:0";
config_map["reqdata_together"]="i:1";
config_map["writeresp_enable"]="i:1";
config_map["addr"]="i:1";
config_map["addr_wdth"]="i:64";
config_map["addrspace"]="i:0";
config_map["addrspace_wdth"]="i:1";
config_map["atomiclength"]="i:0";
config_map["atomiclength_wdth"]="i:1";
config_map["burstlength"]="i:1";
config_map["burstlength_wdth"]="i:0";
config_map["blockheight"]="i:0";
config_map["blockheight_wdth"]="i:1";
config_map["blockstride"]="i:0";
config_map["blockstride_wdth"]="i:1";
config_map["burstprecise"]="i:0";
config_map["burstseq"]="i:0";
config_map["burstsinglereq"]="i:0";
config_map["byteen"]="i:1";
config_map["cmdaccept"]="i:1";
config_map["connid"]="i:0";
config_map["connid_wdth"]="i:1";
config_map["dataaccept"]="i:0";
config_map["datalast"]="i:0";
config_map["datarowlast"]="i:0";
config_map["data_wdth"]="i:0";
config_map["mdata"]="i:1";
config_map["mdatabyteen"]="i:1";
config_map["mdatainfo"]="i:0";
config_map["mdatainfo_wdth"]="i:1";
config_map["mdatainfobyte_wdth"]="i:1";
config_map["sdatathreadbusy"]="i:0";
config_map["mthreadbusy"]="i:0";
config_map["reqinfo"]="i:0";
config_map["reqinfo_wdth"]="i:1";
config_map["reqlast"]="i:0";
config_map["reqrowlast"]="i:0";
config_map["resp"]="i:1";
config_map["respaccept"]="i:1";
config_map["respinfo"]="i:0";
config_map["respinfo_wdth"]="i:1";
config_map["resplast"]="i:0";
config_map["resprowlast"]="i:0";
config_map["sdata"]="i:1";
config_map["sdatainfo"]="i:0";
config_map["sdatainfo_wdth"]="i:1";
config_map["sdatainfobyte_wdth"]="i:1";
config_map["sthreadbusy"]="i:0";
config_map["threads"]="i:1";
config_map["tags"]="i:1";
config_map["taginorder"]="i:0";
config_map["control"]="i:0";
config_map["controlbusy"]="i:0";
config_map["control_wdth"]="i:1";
config_map["controlwr"]="i:0";
config_map["interrupt"]="i:0";
config_map["merror"]="i:0";
config_map["mflag"]="i:0";
config_map["mflag_wdth"]="i:1";
config_map["mreset"]="i:0";
config_map["serror"]="i:0";
config_map["sflag"]="i:0";
config_map["sflag_wdth"]="i:1";
config_map["sreset"]="i:0";
config_map["status"]="i:0";
config_map["statusbusy"]="i:0";
config_map["statusrd"]="i:0";
config_map["status_wdth"]="i:1";
config_map["sthreadbusy_pipelined"]="i:0";
config_map["mthreadbusy_pipelined"]="i:0";
config_map["sdatathreadbusy_pipelined"]="i:0";

*/
