///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :  A class that contains all the ocp parameters and shall
//                 be used to configure an ocp socket
//
//                 Basically there are two classes. One for socket internal
//                 use only (ocp_parameters_configurable) that enables to use
//                 external configuration tools to configure sockets.
//
//                 The other one (ocp_parameters) shall be used by users.
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


OCPIP_VERSION::ocp_parameters_configurable::ocp_parameters_configurable(const std::string& owner_name)
  : ocp_version(owner_name+".ocp_version",2.0)                // NOTE: currently no way to change this.
  , name(owner_name+".name","unnamed_ocp_channel")     // NOTE: set in "setConfiguration(owner_name+)"
  , broadcast_enable(owner_name+".broadcast_enable",false)         // Is the Broadcast command supported?
  , burst_aligned(owner_name+".burst_aligned",false)            // Are bursts forced to be aligned by power of two?
  , burstseq_dflt1_enable(owner_name+".burstseq_dflt1_enable",false)    // Is DFLT1 burst mode enabled?
  , burstseq_dflt2_enable(owner_name+".burstseq_dflt2_enable",false)    // Is DFLT2 burst mode enabled?
  , burstseq_incr_enable(owner_name+".burstseq_incr_enable",true)      // Are Incrementing Bursts allowed?
  , burstseq_strm_enable(owner_name+".burstseq_strm_enable",false)     // Are Streaming Bursts allowed?
  , burstseq_unkn_enable(owner_name+".burstseq_unkn_enable",false)     // Is UNKN burst mode enabled?
  , burstseq_wrap_enable(owner_name+".burstseq_wrap_enable",false)     // Is WRAP burst mode enabled?
  , burstseq_xor_enable(owner_name+".burstseq_xor_enable",false)      // Is XOR burst mode enabled?
  , burstseq_blck_enable(owner_name+".burstseq_blck_enable",false)
  , endian(owner_name+".endian",1)                       // Endian is an int
  , force_aligned(owner_name+".force_aligned",false)            // Forces the byte-enable patterns to be powers of two.
  , mthreadbusy_exact(owner_name+".mthreadbusy_exact",false)        // Slave must use MTheadbusy to send Resp. Master must accept immediately on non-busy threads.
  , rdlwrc_enable(owner_name+".rdlwrc_enable",false)            
  , read_enable(owner_name+".read_enable",true)               // Is the Read command supported?
  , readex_enable(owner_name+".readex_enable",false)            // Is the ReadEx command supported?
  , sdatathreadbusy_exact(owner_name+".sdatathreadbusy_exact",false)    // Master must use SDataThreadBusy to send new Data. Slave must accept new data immediately on non-busy threads.
  , sthreadbusy_exact(owner_name+".sthreadbusy_exact",false)        // Master must use SThreadBusy to send new Request. Slave must accept new request immediately on non-busy threads.
  , write_enable(owner_name+".write_enable",true)              // Is the Write command supported?
  , writenonpost_enable(owner_name+".writenonpost_enable",false)      // Is the WriteNonPost command supported?
  , datahandshake(owner_name+".datahandshake",false)            // Is there a separate channel for request data?
  , reqdata_together(owner_name+".reqdata_together",false)         // Master always puts Request and Data in same cycle. Slave always accepts together in same cycle. 
  , writeresp_enable(owner_name+".writeresp_enable",false)         // Should Responses be sent for write commands?
  , addr(owner_name+".addr",true)                      // Is MAddr (owner_name+Requst Address) part of the OCP?
  , addr_wdth(owner_name+".addr_wdth",2)                    // Address width must be set by user if addr(owner_name+".",true. No default value.
  , addrspace(owner_name+".addrspace",false)                // Is the MAddrSpace signal part of the OCP?
  , addrspace_wdth(owner_name+".addrspace_wdth",1)               // No default value. Must be user specificied.
  , atomiclength(owner_name+".atomiclength",false)             // Is there a minimum number of transfers to hold together during a burst?
  , atomiclength_wdth(owner_name+".atomiclength_wdth",1)            // The minimum number. No default value.
  , burstlength(owner_name+".burstlength",false)              // Is there a set number of transfers in a burst.
  , burstlength_wdth(owner_name+".burstlength_wdth",1)             // The number of transfers in a burst. User defined. No default value.
  , blockheight(owner_name+".blockheight",false)
  , blockheight_wdth(owner_name+".blockheight_wdth",1)
  , blockstride(owner_name+".blockstride",false)
  , blockstride_wdth(owner_name+".blockstride_wdth",1)
  , burstprecise(owner_name+".burstprecise",false)             // Will the length of a burst be known at the start of the burst?
  , burstseq(owner_name+".burstseq",false)                 // Is there a sequence of addresses in a burst?
  , burstsinglereq(owner_name+".burstsinglereq",false)           // Is a single request allowed to generate multiple data transfers in a burst?
  , byteen(owner_name+".byteen",false)                   // Is MByteEn part of the OCP?
  , cmdaccept(owner_name+".cmdaccept",true)                 // Does slave accept commands?
  , connid(owner_name+".connid",false)                   // Is MConnID connection identifier pard of the Request group?
  , connid_wdth(owner_name+".connid_wdth",1)                  // Width of MConnID. User specified. No default.
  , dataaccept(owner_name+".dataaccept",false)               // Does slave accept data handshakes?
  , datalast(owner_name+".datalast",false)                 // Is the MDataLast burst signal part of the OCP? 
  , datarowlast(owner_name+".datarowlast",false)
  , data_wdth(owner_name+".data_wdth",32)                   // width of MData. User specified. No default.
  , mdata(owner_name+".mdata",true)                     // is MData part of the OCP?
  , mdatabyteen(owner_name+".mdatabyteen",false)              // is the MDataByteEn signal in the OCP? 
  , mdatainfo(owner_name+".mdatainfo",false)                // is the MDataInfo signal in the OCP?
  , mdatainfo_wdth(owner_name+".mdatainfo_wdth",1)               // Width of MDataInfo. User specified. no default.
  , mdatainfobyte_wdth(owner_name+".mdatainfobyte_wdth",1)           // Number of bits of MDataInfo that are associated with each data byte of MData.
  , sdatathreadbusy(owner_name+".sdatathreadbusy",false)          // Is SDataThreadBusy part of the OCP channel?
  , mthreadbusy(owner_name+".mthreadbusy",false)              // Is MThreadBusy part of the OCP channel?
  , reqinfo(owner_name+".reqinfo",false)                  // Is the MReqInfo signal part of the OCP channel?
  , reqinfo_wdth(owner_name+".reqinfo_wdth",1)                 // Width of MReqInfo. User Specified. No default.
  , reqlast(owner_name+".reqlast",false)                  // Is the MReqLast burst signal part of the OCP channel?
  , reqrowlast(owner_name+".reqrowlast",false)
  , resp(owner_name+".resp",true)                      // Is the SResp signal part of the OCP channel?
  , respaccept(owner_name+".respaccept",false)               // Does the Master accept Responses with the MRespAccept signal?
  , respinfo(owner_name+".respinfo",false)                 // Is the SRespInfo signal on the OCP?
  , respinfo_wdth(owner_name+".respinfo_wdth",1)                // Width of SRespInfo. User Specified. No Default.
  , resplast(owner_name+".resplast",false)                 // Is the SRespLast burst signal part of the OCP channel? 
  , resprowlast(owner_name+".resprowlast",false)
  , sdata(owner_name+".sdata",true)                     // Is the SData signal part of the OCP channel?
  , sdatainfo(owner_name+".sdatainfo",false)                // Is the SDataInfo signal supported?
  , sdatainfo_wdth(owner_name+".sdatainfo_wdth",1)               // Width of SDataInfo. User Specified. No default.
  , sdatainfobyte_wdth(owner_name+".sdatainfobyte_wdth",1)           // Number of bits in SDataInfo devoted to each byte of SData. User Specified. No default.
  , sthreadbusy(owner_name+".sthreadbusy",false)              // Is the SThreadBusy signal supported?
  , threads(owner_name+".threads",1)                      // Number of threads allowed.
  , tags(owner_name+".tags",1)                         // Number of tags allowed. 
  , taginorder(owner_name+".taginorder",false)                   // In order required among tags  
  , control(owner_name+".control",false)                  // Is the Sideband Control signal supported?
  , controlbusy(owner_name+".controlbusy",false)              // Is the Sideband ControlBusy signal supported?
  , control_wdth(owner_name+".control_wdth",1)                 // Width of ControlBusy. User Specified. No default.
  , controlwr(owner_name+".controlwr",false)                // Is the Sideband ControlWr signal supported?
  , interrupt(owner_name+".interrupt",false)                // Is the Sideband SInterrupt signal supported?
  , merror(owner_name+".merror",false)                   // Is the Sideband MError signal supported?
  , mflag(owner_name+".mflag",false)                    // Is the Sideband MFlag signal supported?
  , mflag_wdth(owner_name+".mflag_wdth",1)                   // Width of MFlag. User Specified. No default.
  , mreset(owner_name+".mreset",false)                   // NOTE: no default. Is the Sideband MReset signal supported?
  , serror(owner_name+".serror",false)                   // Is the Sideband SError signal supported?
  , sflag(owner_name+".sflag",false)                    // Is the Sideband SFlag signal supported?
  , sflag_wdth(owner_name+".sflag_wdth",1)                   // Width of SFlag. User Specified. No default.
  , sreset(owner_name+".sreset",false)                   // Note: no default. Is the SReset signal part of the OCP channel?
  , status(owner_name+".status",false)                   // Is the Sideband Status signal supported?
  , statusbusy(owner_name+".statusbusy",false)               // Is the Sideband StatusBusy signal supported
  , statusrd(owner_name+".statusrd",false)                 // Is the Sideband StatusRd signal supported?
  , status_wdth(owner_name+".status_wdth",1)                  // Width of Status. User Specified. No default.
  , sthreadbusy_pipelined(owner_name+".sthreadbusy_pipelined",false)
  , mthreadbusy_pipelined(owner_name+".mthreadbusy_pipelined",false)
  , sdatathreadbusy_pipelined(owner_name+".sdatathreadbusy_pipelined",false)
  , config_state(owner_name+".config_state",ocp_unconfigured)
{
}

#define COPY_FROM_OTHER(name) name=other.name
OCPIP_VERSION::ocp_parameters_configurable& 
  OCPIP_VERSION::ocp_parameters_configurable::operator=(const ocp_parameters& other)
{
  COPY_FROM_OTHER(ocp_version);
  COPY_FROM_OTHER(name); 
  COPY_FROM_OTHER(broadcast_enable);
  COPY_FROM_OTHER(burst_aligned);
  COPY_FROM_OTHER(burstseq_dflt1_enable);
  COPY_FROM_OTHER(burstseq_dflt2_enable);
  COPY_FROM_OTHER(burstseq_incr_enable);
  COPY_FROM_OTHER(burstseq_strm_enable);
  COPY_FROM_OTHER(burstseq_unkn_enable);
  COPY_FROM_OTHER(burstseq_wrap_enable);
  COPY_FROM_OTHER(burstseq_xor_enable);
  COPY_FROM_OTHER(burstseq_blck_enable);
  COPY_FROM_OTHER(endian);
  COPY_FROM_OTHER(force_aligned);
  COPY_FROM_OTHER(mthreadbusy_exact);
  COPY_FROM_OTHER(rdlwrc_enable);
  COPY_FROM_OTHER(read_enable);
  COPY_FROM_OTHER(readex_enable);
  COPY_FROM_OTHER(sdatathreadbusy_exact);
  COPY_FROM_OTHER(sthreadbusy_exact);
  COPY_FROM_OTHER(write_enable);
  COPY_FROM_OTHER(writenonpost_enable);
  COPY_FROM_OTHER(datahandshake);
  COPY_FROM_OTHER(reqdata_together);
  COPY_FROM_OTHER(writeresp_enable);
  COPY_FROM_OTHER(addr);
  COPY_FROM_OTHER(addr_wdth);
  COPY_FROM_OTHER(addrspace);
  COPY_FROM_OTHER(addrspace_wdth);
  COPY_FROM_OTHER(atomiclength);
  COPY_FROM_OTHER(atomiclength_wdth);
  COPY_FROM_OTHER(burstlength);
  COPY_FROM_OTHER(burstlength_wdth);
  COPY_FROM_OTHER(blockheight);
  COPY_FROM_OTHER(blockheight_wdth);
  COPY_FROM_OTHER(blockstride);
  COPY_FROM_OTHER(blockstride_wdth);
  COPY_FROM_OTHER(burstprecise);
  COPY_FROM_OTHER(burstseq);
  COPY_FROM_OTHER(burstsinglereq);
  COPY_FROM_OTHER(byteen);
  COPY_FROM_OTHER(cmdaccept);
  COPY_FROM_OTHER(connid);
  COPY_FROM_OTHER(connid_wdth);
  COPY_FROM_OTHER(dataaccept);
  COPY_FROM_OTHER(datalast);
  COPY_FROM_OTHER(datarowlast);
  COPY_FROM_OTHER(data_wdth);
  COPY_FROM_OTHER(mdata);
  COPY_FROM_OTHER(mdatabyteen);
  COPY_FROM_OTHER(mdatainfo);
  COPY_FROM_OTHER(mdatainfo_wdth);
  COPY_FROM_OTHER(mdatainfobyte_wdth);
  COPY_FROM_OTHER(sdatathreadbusy);
  COPY_FROM_OTHER(mthreadbusy);
  COPY_FROM_OTHER(reqinfo);
  COPY_FROM_OTHER(reqinfo_wdth);
  COPY_FROM_OTHER(reqlast);
  COPY_FROM_OTHER(reqrowlast);
  COPY_FROM_OTHER(resp);
  COPY_FROM_OTHER(respaccept);
  COPY_FROM_OTHER(respinfo);
  COPY_FROM_OTHER(respinfo_wdth);
  COPY_FROM_OTHER(resplast);
  COPY_FROM_OTHER(resprowlast);
  COPY_FROM_OTHER(sdata);
  COPY_FROM_OTHER(sdatainfo);
  COPY_FROM_OTHER(sdatainfo_wdth);
  COPY_FROM_OTHER(sdatainfobyte_wdth);
  COPY_FROM_OTHER(sthreadbusy);
  COPY_FROM_OTHER(threads);
  COPY_FROM_OTHER(tags);
  COPY_FROM_OTHER(taginorder);
  COPY_FROM_OTHER(control);
  COPY_FROM_OTHER(controlbusy);
  COPY_FROM_OTHER(control_wdth);
  COPY_FROM_OTHER(controlwr);
  COPY_FROM_OTHER(interrupt);
  COPY_FROM_OTHER(merror);
  COPY_FROM_OTHER(mflag);
  COPY_FROM_OTHER(mflag_wdth);
  COPY_FROM_OTHER(mreset);
  COPY_FROM_OTHER(serror);
  COPY_FROM_OTHER(sflag);
  COPY_FROM_OTHER(sflag_wdth);
  COPY_FROM_OTHER(sreset);
  COPY_FROM_OTHER(status);
  COPY_FROM_OTHER(statusbusy);
  COPY_FROM_OTHER(statusrd);
  COPY_FROM_OTHER(status_wdth);
  COPY_FROM_OTHER(sthreadbusy_pipelined);
  COPY_FROM_OTHER(mthreadbusy_pipelined);
  COPY_FROM_OTHER(sdatathreadbusy_pipelined);
  COPY_FROM_OTHER(config_state); 
  return *this;
}
#undef COPY_FROM_OTHER

#define COPY_TO_TMP(name) tmp.name=name
OCPIP_VERSION::ocp_parameters OCPIP_VERSION::ocp_parameters_configurable::get_params() const{
  ocp_parameters tmp;
  COPY_TO_TMP(ocp_version);
  COPY_TO_TMP(name);
  COPY_TO_TMP(broadcast_enable);
  COPY_TO_TMP(burst_aligned);
  COPY_TO_TMP(burstseq_dflt1_enable);
  COPY_TO_TMP(burstseq_dflt2_enable);
  COPY_TO_TMP(burstseq_incr_enable);
  COPY_TO_TMP(burstseq_strm_enable);
  COPY_TO_TMP(burstseq_unkn_enable);
  COPY_TO_TMP(burstseq_wrap_enable);
  COPY_TO_TMP(burstseq_xor_enable);
  COPY_TO_TMP(burstseq_blck_enable);
  COPY_TO_TMP(endian);
  COPY_TO_TMP(force_aligned);
  COPY_TO_TMP(mthreadbusy_exact);
  COPY_TO_TMP(rdlwrc_enable);
  COPY_TO_TMP(read_enable);
  COPY_TO_TMP(readex_enable);
  COPY_TO_TMP(sdatathreadbusy_exact);
  COPY_TO_TMP(sthreadbusy_exact);
  COPY_TO_TMP(write_enable);
  COPY_TO_TMP(writenonpost_enable);
  COPY_TO_TMP(datahandshake);
  COPY_TO_TMP(reqdata_together);
  COPY_TO_TMP(writeresp_enable);
  COPY_TO_TMP(addr);
  COPY_TO_TMP(addr_wdth);
  COPY_TO_TMP(addrspace);
  COPY_TO_TMP(addrspace_wdth);
  COPY_TO_TMP(atomiclength);
  COPY_TO_TMP(atomiclength_wdth);
  COPY_TO_TMP(burstlength);
  COPY_TO_TMP(burstlength_wdth);
  COPY_TO_TMP(blockheight);
  COPY_TO_TMP(blockheight_wdth);
  COPY_TO_TMP(blockstride);
  COPY_TO_TMP(blockstride_wdth);
  COPY_TO_TMP(burstprecise);
  COPY_TO_TMP(burstseq);
  COPY_TO_TMP(burstsinglereq);
  COPY_TO_TMP(byteen);
  COPY_TO_TMP(cmdaccept);
  COPY_TO_TMP(connid);
  COPY_TO_TMP(connid_wdth);
  COPY_TO_TMP(dataaccept);
  COPY_TO_TMP(datalast);
  COPY_TO_TMP(datarowlast);
  COPY_TO_TMP(data_wdth);
  COPY_TO_TMP(mdata);
  COPY_TO_TMP(mdatabyteen);
  COPY_TO_TMP(mdatainfo);
  COPY_TO_TMP(mdatainfo_wdth);
  COPY_TO_TMP(mdatainfobyte_wdth);
  COPY_TO_TMP(sdatathreadbusy);
  COPY_TO_TMP(mthreadbusy);
  COPY_TO_TMP(reqinfo);
  COPY_TO_TMP(reqinfo_wdth);
  COPY_TO_TMP(reqlast);
  COPY_TO_TMP(reqrowlast);
  COPY_TO_TMP(resp);
  COPY_TO_TMP(respaccept);
  COPY_TO_TMP(respinfo);
  COPY_TO_TMP(respinfo_wdth);
  COPY_TO_TMP(resplast);
  COPY_TO_TMP(resprowlast);
  COPY_TO_TMP(sdata);
  COPY_TO_TMP(sdatainfo);
  COPY_TO_TMP(sdatainfo_wdth);
  COPY_TO_TMP(sdatainfobyte_wdth);
  COPY_TO_TMP(sthreadbusy);
  COPY_TO_TMP(threads);
  COPY_TO_TMP(tags);
  COPY_TO_TMP(taginorder);
  COPY_TO_TMP(control);
  COPY_TO_TMP(controlbusy);
  COPY_TO_TMP(control_wdth);
  COPY_TO_TMP(controlwr);
  COPY_TO_TMP(interrupt);
  COPY_TO_TMP(merror);
  COPY_TO_TMP(mflag);
  COPY_TO_TMP(mflag_wdth);
  COPY_TO_TMP(mreset);
  COPY_TO_TMP(serror);
  COPY_TO_TMP(sflag);
  COPY_TO_TMP(sflag_wdth);
  COPY_TO_TMP(sreset);
  COPY_TO_TMP(status);
  COPY_TO_TMP(statusbusy);
  COPY_TO_TMP(statusrd);
  COPY_TO_TMP(status_wdth);
  COPY_TO_TMP(sthreadbusy_pipelined);
  COPY_TO_TMP(mthreadbusy_pipelined);
  COPY_TO_TMP(sdatathreadbusy_pipelined);
  COPY_TO_TMP(config_state);
  return tmp;
}
#undef COPY_TO_TMP
