// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//         Date : 06/10/2004
//
//  Description : Transaction Level - Layer-0 to Layer-1 Master Adapter (OCP2.0)
//                This adapter is an extension of the 'basic' master adapter,
//                adding OCP burst signals support.
//
// ============================================================================

#ifndef _OCP_TL0_TL1_MASTER_ADAPTER_BURST_H
#define _OCP_TL0_TL1_MASTER_ADAPTER_BURST_H

#include "ocp_globals.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_master_port.h"

template <class TdataCl> class OCP_TL0_TL1_Master_Adapter_Burst
  : public sc_module
  , public MdirectIF<TdataCl>
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // TL1 Master Port
  OCP_TL1_MasterPort<TdataCl> MasterP;

  // TL0 Basic OCP Slave ports
  sc_in_clk           Clk;
  sc_in	  <sc_bv<3> >	MCmd;
  sc_in 	<Ta>      	MAddr;
  sc_in 	<Td>      	MData;
  sc_out	<bool>	    SCmdAccept;
  sc_out	<Td>      	SData;
  sc_out	<sc_bv<2> > SResp;
  sc_in 	<bool>	    MRespAccept;

  // TL0 Burst Extension
  sc_in <unsigned int>   MByteEn;
  sc_in	<unsigned int>   MBurstLength;
  sc_in	<bool>        MBurstPrecise;
  sc_in	<OCPMBurstSeqType >   MBurstSeq;
  sc_in	<bool>        MBurstSingleReq;

  SC_HAS_PROCESS(OCP_TL0_TL1_Master_Adapter_Burst);

  // Default constructor: no need to specify explicit sampling times, use default ones
  OCP_TL0_TL1_Master_Adapter_Burst(sc_module_name name_
             , int ID
             , int Priority
             , bool Combinational
             , sc_time ClockCycle
             , bool Check_setup_time = true
            );

  // constructor with explicit sampling timings
  OCP_TL0_TL1_Master_Adapter_Burst(sc_module_name name_
             , int ID
             , int Priority
             , sc_time RequestSampleDelay 
             , sc_time RespAcceptSampleDelay 
             , bool Check_setup_time = true    
            );


  // destructor
  ~OCP_TL0_TL1_Master_Adapter_Burst();

  // methods
  virtual bool SputDirect(int, bool, Td*, Ta, int);
  void send_Request();
  void set_reset_SCmdAccept_PE();
  void set_SCmdAccept_Normal();
  void reset_SCmdAccept_Normal();
  void reset_TL0_signals();
  void send_Response();
  void release_Response();
  void sample_events_trigger();
  void check_respaccept_setup_time();
  void check_request_setup_time();

private :

  void end_of_elaboration();
  
  // Structures used to handle TL1 Requests/Responses
  OCPResponseGrp<Td>   TL1_response;
  OCPRequestGrp<Td,Ta>   TL1_request;

  // Pointer to the communication class of the channel
  CommCl           *m_CommCl;

  // Pointer to the parameter class of the channel
  ParamCl<TdataCl>           *m_ParamCl;

  // parameters
  sc_event e_request_sample_event;
  sc_event e_respaccept_sample_event;
  int m_ID; 
  int m_Priority;
  sc_time m_request_sample_delay;
  sc_time m_respaccept_sample_delay;
  bool m_check_active;
  sc_time m_last_rising_edge;
  bool m_default_values;
  bool m_response_in_progress;
  bool m_PE_mode;

  bool m_request_accepted;
  bool m_ready_for_request;

};


#endif // _OCP_TL0_TL1_MASTER_ADAPTER_BURST_H
