// 
//  (c) Copyright OCP-IP 2003 - 2006
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Tim Kogel, CoWare, Inc.
//           $Id:
//
//  Description : OCP TL3 Slave multiport
//
// ============================================================================

#ifndef OCP_TL3_SLAVEMULTIPORT_H
#define OCP_TL3_SLAVEMULTIPORT_H

#include "multiport_event_finder.h"
#include "ocp_tl3_slave_if.h"


template<typename REQ, typename RESP>
class OCP_TL3_SlaveMultiPort
  : public sc_port<OCP_TL3_SlaveIF<REQ, RESP>, 0> {
 public:
  OCP_TL3_SlaveMultiPort(const char* name )
    : sc_port<OCP_TL3_SlaveIF<REQ, RESP>, 0>(name)
  {}

  // Access to the "in-band" events of the OCP TL3 Channel using event finders
  sc_event_finder& RequestStartEvent(int myPort = 0) const 
  { 
    return *new multiport_event_finder_t<OCP_TL3_SlaveIF<REQ, RESP> >( *this, &OCP_TL3_SlaveIF<REQ, RESP>::RequestStartEvent, myPort ); 
  }
  sc_event_finder& RequestEndEvent(int myPort = 0) const 
  { 
    return *new multiport_event_finder_t<OCP_TL3_SlaveIF<REQ, RESP> >( *this, &OCP_TL3_SlaveIF<REQ, RESP>::RequestEndEvent, myPort ); 
  }
  sc_event_finder& ResponseStartEvent(int myPort = 0) const 
  { 
    return *new multiport_event_finder_t<OCP_TL3_SlaveIF<REQ, RESP> >( *this, &OCP_TL3_SlaveIF<REQ, RESP>::ResponseStartEvent, myPort ); 
  }
  sc_event_finder& ResponseEndEvent(int myPort = 0) const 
  { 
    return *new multiport_event_finder_t<OCP_TL3_SlaveIF<REQ, RESP> >( *this, &OCP_TL3_SlaveIF<REQ, RESP>::ResponseEndEvent, myPort ); 
  } 
};


#endif
