// 
//  Copyright 2005 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: slave.cc,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 AMBD profile example
// ============================================================================

#include "slave.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Slave::Slave (sc_module_name name_)
  : sc_module (name_), ipP("wPort") {

  // initialize common members
  is_req = false;
  request = false;
  address = 0;
  burststart = true;
  burstlen = 0;
  bytemask = 0;
  data_pending = false;
  for (int i=0;i<1024;i++)
    memory[i] = 0;

  SC_METHOD(proc);
  sensitive_pos(clk);
  dont_initialize(); 
}


// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Slave::~Slave(){}


// ----------------------------------------------------------------------------
//  Method : Slave::proc()
//
//  Synchronous slave port process
//
// ----------------------------------------------------------------------------

void Slave::proc(){

  bool tmp;


  // Request handshake
  is_req = ipP->getOCPRequest(req);

  if (is_req) 
#ifdef DEBUG_G1
    cout << "Slave got request "
	 << " time " << sc_time_stamp().to_seconds()
	 << " MCmd " << req.MCmd
	 << " MAddr " << req.MAddr << endl;
#endif
  
   
  if (is_req || request) {
    if (!req_fifo.full()) {
      
      // Burst addressing
      if (burstlen == 0) {
	address = req.MAddr/4; // First of burst
	burstlen = req.MBurstLength;
	command = req.MCmd;
      }
      else {
	if (req.MBurstSeq==OCP_MBURSTSEQ_INCR)
	  address = address+1; //incrementing address
	else if (req.MBurstSeq==OCP_MBURSTSEQ_STRM)
	  address = address; //streaming address
      }
      
      
      burstlen--;

      request = false;
      if (burstlen>0) {
	if (req.MBurstSingleReq) {
	  request = true;
	  if (cmd_fifo.peek() == OCP_MCMD_WR)
	    req_fifo.poke_flag(0); // For marking whether there needs to
	                          // be a response
	  else
	    req_fifo.poke_flag(1);
	}
	else {
	  ipP->putSCmdAccept();
	  req_fifo.poke_flag(1);
#ifdef DEBUG_G1
	  cout << "Slave accepted write request "
	       << " time " << sc_time_stamp().to_seconds() << endl;
#endif

	}
      }
      else {
	  ipP->putSCmdAccept();
	  req_fifo.poke_flag(1);

#ifdef DEBUG_G1
	  cout << "Slave accepted write request "
	       << " time " << sc_time_stamp().to_seconds() << endl;
#endif

      }
      req_fifo.write(address);
      cmd_fifo.write(command);
    }
    else
      request = true;
  }

  // Data handshake
  if (!req_fifo.empty() && !resp_fifo.full()) {
    if (cmd_fifo.peek() == OCP_MCMD_WR) {
      is_data = ipP->getOCPDataHS(req_data, true);
      if (is_data) {
	// Byte enable to bitmask
	if (req_data.MDataByteEn & 0x1)
	  bytemask = 0xFF; 
	if  (req_data.MDataByteEn & 0x2)
	  bytemask = 0xFF00 | bytemask; 
	if  (req_data.MDataByteEn & 0x4)
	  bytemask = 0xFF0000 | bytemask; 
	if  (req_data.MDataByteEn & 0x8)
	  bytemask = 0xFF000000 | bytemask; 
	
	memory[req_fifo.peek()] = req_data.MData & bytemask;
	if (req_fifo.peek_flag()) {
	  resp_fifo.write(req_data.MData); // push response fifo
	}
	req_fifo.read();
	cmd_fifo.read();
#ifdef DEBUG_G1
	cout << "Slave got data "
	     << " time " << sc_time_stamp().to_seconds()
	     << " MData " << req_data.MData << endl;
#endif
      }
    }
    else {
      resp_fifo.write(memory[ req_fifo.read()]); // push response fifo
    }
  }

  // Response handshake
  if (!resp_fifo.empty()) {
    tmp = ipP->getMBusy();
    if (!tmp) {
      // Set OCP response
      resp.SResp = OCP_SRESP_DVA;
      resp.SData = resp_fifo.read();
      // Send response
      ipP->startOCPResponse(resp);

#ifdef DEBUG_G1
      cout << "Slave sent response "
	   << " time " << sc_time_stamp().to_seconds()
	   << " SResp " << resp.SResp << endl;
#endif

    }
  }
  
} // end of method

