// (c) Copyright OCP-IP 2004-2006
// OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Original Authors :
//                Anssi Haverinen, Nokia Inc.
//                Alan Kamas, for Sonics Inc.
//                Joe Chou, Sonics Inc.
//                James Aldis, Texas Instruments Inc.
//		  Tim Kogel, CoWare Inc.
//           $Id: ocp_tl1_trace_monitor.h,v 1.3 2006/09/04 14:01:07 tkogel Exp $
//
//  Description : Monitor component for OCP TL1 transaction API
//                Prints out a CoreCreator-compatible trace file.
//                Note: Instantiate after the channel monitored has been configured.
//   Old History:
//          04/09/2004 Original revision, based on Dec 2003 OCP TL1 channel
//          07/02/2004 Changed time to simulation time.
//          05/08/2004 Added a destructor so that
//                     the m_ocpMonPtr destructor can be called.
//	    02/03/2006 New unified monitor interface, renamed file
//	    09/06/2006 separate trace monitors for clocked and untimed channel
//
// ============================================================================


#ifndef _OCP_TL1_TRACE_MONITOR_H
#define _OCP_TL1_TRACE_MONITOR_H

#include "ocp_tl1_trace_monitor_clocked.h"

// for backwards compatibility ...
template<typename TdataCl>
class OCP_TL1_Trace_Monitor : public OCP_TL1_Trace_Monitor_Clocked<TdataCl> 
{
 public:
  OCP_TL1_Trace_Monitor(sc_module_name mn,
			std::string monFileName = "",
			bool print_params = true)
    : OCP_TL1_Trace_Monitor_Clocked<TdataCl>(mn, monFileName, print_params)
  {}
};

#endif // _OCP_TL1_TRACE_MONITOR_H
