// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//                Stphane Guntz, PROSILOG, guntz@prosilog.com
//         Date : 03/10/2003
//
//  Description : Transaction Level - Layer-0 to Layer-1 Master Adapter
//
// ============================================================================

#ifndef _OCP_TL0_TL1_MASTER_ADAPTER_H
#define _OCP_TL0_TL1_MASTER_ADAPTER_H

#include "ocp_tl1_globals.h"
#include "tl_master_port.h"

template <class TdataCl> class OCP_TL0_TL1_Master_Adapter
  : public sc_module
  , public MdirectIF<TdataCl>
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // TL1 Master Port
  tl_master_port<TdataCl> MasterP;

  // TL0 Basic OCP Slave ports
  sc_in_clk             Clk;
  sc_in	  <sc_bv<3> >	MCmd;
  sc_in 	<Ta>      	MAddr;
  sc_in 	<Td>      	MData;
  sc_out	<bool>	    SCmdAccept;
  sc_out	<Td>      	SData;
  sc_out	<sc_bv<2> > SResp;
  sc_in 	<bool>	    MRespAccept;

  SC_HAS_PROCESS(OCP_TL0_TL1_Master_Adapter);

  // Default constructor: no need to specify explicit sampling times, use default ones
  OCP_TL0_TL1_Master_Adapter(sc_module_name name_
             , int ID
             , int Priority
             , bool Combinational
             , sc_time ClockCycle
             , bool Check_setup_time = true
            );

  // constructor with explicit sampling timings
  OCP_TL0_TL1_Master_Adapter(sc_module_name name_
             , int ID
             , int Priority
             , sc_time RequestSampleDelay 
             , sc_time RespAcceptSampleDelay 
             , bool Check_setup_time = true    
            );


  // destructor
  ~OCP_TL0_TL1_Master_Adapter();

  // methods
  virtual bool SputDirect(int, bool, Td*, Ta, int);
  void send_Request();
  void set_SCmdAccept();
  void reset_TL0_signals();
  void send_Response();
  void release_Response();
  void sample_events_trigger();
  void check_respaccept_setup_time();
  void check_request_setup_time();

private :

  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl          *m_DataCl;
  ParamCl<TdataCl> *m_ParamCl;
  CommCl           *m_CommCl;

  // parameters
  sc_event e_request_sample_event;
  sc_event e_respaccept_sample_event;
  int m_ID; 
  int m_Priority;
  sc_time m_request_sample_delay;
  sc_time m_respaccept_sample_delay;
  bool m_check_active;
  sc_time m_last_rising_edge;
  bool m_default_values;
};


#endif // _OCP_TL0_TL1_MASTER_ADAPTER_H
