// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level Layer-1
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//                Alan Kamas, www.kamas.com
//         Date : June/06/2003
//
//  Description : Transaction Level - Layer-1 example
//                Top level, synchronous Master <---> synchronous Slave
//                Sync Master Sideband signal MFlag ---> clocked Slave
//
// ============================================================================

#include "ocp_tl1_master_sync_sideband.h"
#include "ocp_tl1_slave_sync_sideband.h"
#include "ocp_tl1_data_cl.h"
#include "tl_channel.h"  

#include "ModelConfigCl.h"  

int sc_main(int, char*[])
{
  // construct the model configuration database
  ModelConfigCl MCDatabase("simple.sci");

  //
  bool sync = true;
  TL_Channel<TL1_TEMPL_DATA_CL > ch0("ch0", sync);

#ifdef USEANTLR
  // setup ch0's configuration
  ParamCl<TL1_TEMPL_DATA_CL >* ch0_param_ptr = ch0.GetParamCl();
  ch0_param_ptr->setOCPConfiguration("ch0",MCDatabase);
  ch0_param_ptr->dumpConfiguration();
#endif


  // Try reversing the next two declarations: Causes change in thread order.

  OCP_TL1_Master_Sync_Sideband<TL1_TEMPL_DATA_CL > ms1("ms1", 1, 1, 20);
  OCP_TL1_Slave_Sync_Sideband<TL1_TEMPL_DATA_CL > sl1("sl1", 1, 0x0, 0x3FF);
  sc_clock clk("clock", TL_CLK_PERIOD, TL_TIME_UNIT);

  ms1.MasterP(ch0);
  ms1.clk(clk);
#ifdef USEANTLR
  ms1.setConfiguration("ms1",MCDatabase);
  ms1.dumpConfiguration();
#endif

  sl1.SlaveP(ch0);
  sl1.clk(clk);
#ifdef USEANTLR
  sl1.setConfiguration("sl1",MCDatabase);
  sl1.dumpConfiguration();
#endif

  sc_start(500, SC_NS);

  return(0);
}
