/*****************************************************************************

  The following code is derived, directly or indirectly, from the SystemC
  source code Copyright (c) 1996-2003 by all Contributors.
  All Rights reserved.

  The contents of this file are subject to the restrictions and limitations
  set forth in the SystemC Open Source License Version 2.4 (the "License");
  You may not use this file except in compliance with such restrictions and
  limitations. You may obtain instructions on how to receive a copy of the
  License at http://www.systemc.org/. Software distributed by Contributors
  under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
  ANY KIND, either express or implied. See the License for the specific
  language governing rights and limitations under the License.

 *****************************************************************************/

/*****************************************************************************

  MODIFICATION LOG - modifiers, enter your name, affiliation, date and
  changes you are making here.

      Name, Affiliation, Date:
  Description of Modification:

 *****************************************************************************/

// ============================================================================
//      Project : Generic SystemC TL Communication Methodology
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//         Date : 06/12/2002
//
//  Description : Transaction Level - Layer-3 Slave example.
//
// ============================================================================

#ifndef _TL3_SLAVE_H
#define _TL3_SLAVE_H

#include "tl3_globals.h"
#include "tl_slave_if.h"

template <class TdataCl> class TL3_Slave
  : public sc_module
  , public SdirectIF<TdataCl>
{
public:

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  sc_port<TLslaveIF<TdataCl>, 1> SlaveP;

  SC_HAS_PROCESS(TL3_Slave);

  // constructor
  TL3_Slave(sc_module_name name_
            , int ID
            , bool WriteResponse
           );

  // destructor
  ~TL3_Slave();

  // methods
  virtual bool MputDirect(int, bool, Td*, Ta, int);
  void PrintTrans(int TaNum, Ta Addr, int NumCells, const char *Method);
  void PrintTime(const char *Pstring, int ID, Ta Addr);
  void Slave();

private :

  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl          *m_DataCl;
  ParamCl<TdataCl> *m_ParamCl;
  CommCl           *m_CommCl;

  // Slave parameters
  int m_ID;
  bool m_WriteResponse;

  // Data arrays
  Td *m_SlaveMemory;

  int m_TaNum; // Transaction number
};


#endif // _TL3_SLAVE_H
