// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 03/31/2004
//
//  Description : Generic API - Layer-2 Simple Example pipelined slave
// ============================================================================

#include "slave.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------

template<class TdataCl> Slave<TdataCl>::Slave (sc_module_name name_)
  : sc_module (name_), tpP("tpPort") {

  // initialize common members
  is_req = false;
  tmp = false;
  last_request = OCP_MCMD_IDLE;

  // These must be threads since blocking calls are used
  SC_THREAD(proc_req);
  SC_THREAD(proc_resp);
  sensitive(send_response_event);
}


// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
template<class TdataCl> Slave<TdataCl>::~Slave(){}


// ----------------------------------------------------------------------------
//  Method : Slave::proc_req()
//
//  Slave request receive process
//
// ----------------------------------------------------------------------------

template<class TdataCl> void Slave<TdataCl>::proc_req(){
  bool release = false;
  unsigned int size;
  bool last = true;
  int *mdata;
  sc_time delay = sc_time(2, SC_NS);

  while (true) {
    // Check for request
    is_req = tpP->SgetRequestBlocking(release);
    if (is_req) {
      tpP->Srelease(delay); // Release master after a delay
      // If request was write
      if (tpP->IsWrite()) {
	// This pointer is safe until the next blocking call, or wait()
	mdata = m_DataCl->SgetMData(size, last); 
#ifdef DEBUG_G1
	cout << "Slave got write request "
	     << "  time  = " << sc_time_stamp().to_seconds()
	     << "  data  = " << mdata[0] << endl;
#endif

      }
      else {
	
#ifdef DEBUG_G1
	cout << "Slave got read request "
	     << "  time  = " << sc_time_stamp().to_seconds()
	     << "  address  = " << m_DataCl->SgetMAddr() << endl;
#endif
	// Trigger response thread
	send_response_event.notify(delay);
      }
    }
  }
} // end of method

// ----------------------------------------------------------------------------
//  Method : Slave::proc_resp()
//
//  Slave response process.
//
// ----------------------------------------------------------------------------
template<class TdataCl> void Slave<TdataCl>::proc_resp(){
  resp.SData = 0;
  while(true) {
    wait(); // For response event

    // Set response data
    resp.SResp = OCP_SRESP_DVA;
    m_DataCl->SputSData(&resp.SData);
    m_DataCl->SputSResp(resp.SResp);
#ifdef DEBUG_G1
    cout << "Slave sent response " << resp.SResp
	 << " time " << sc_time_stamp().to_seconds()
	 << " data " << resp.SData << endl;
#endif

    // Send response
    tpP->SputResponseBlocking();
      
    resp.SData++;
  }
} // end of method

template<class TdataCl>
void Slave<TdataCl>::end_of_elaboration()
{
  sc_module::end_of_elaboration();

  // Get data structure
  m_DataCl = tpP->GetDataCl();

  // Get parameters
  m_ParamCl = tpP->GetParamCl();
}

// ----------------------------------------------------------------------------
//
//  Instantiation of the Slave
//
// ----------------------------------------------------------------------------
template class Slave<OCP_TL2_DataCl< int, int >  >; 

