// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level Layer-1
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//				  modified by Yann Bajot, PROSILOG, bajot@prosilog.com 
//                Stephane Guntz, PROSILOG, guntz@prosilog.com
//
//  Description : Transaction Level - Layer-1 example Master
//  $Id: ocp_tl1_master.h,v 1.2 2006/02/09 23:21:56 halexan Exp $
//
//  Description : Transaction Level - Layer-1 example Master
//
// The master sends a READ precise burst, with a total length of 15 elements, at each rising edge of the clock
// The start address is 0, and the address increment is 4.
// The sequence is decomposed as follows:
// At the 4th element (address=12): the MReqInfo field changes and is 1 now..
// 
// For the remaining READ requests: the address increment is still 4, MBurstLength=15, MReqInfo=1
// 
// The adapter separates that 15 TL1-element burst into 4 TL2 chunks:
// The first chunk has a length of 3 (start address=0, end address=8, read data are 0,1,2)
// The second chunk has a length of 5, which is the maximum chunk size: it begins when the MReqInfo has changed (start address=12, end address= 28, read data=3,4,5,6,7)
// The third chunk has a length of 5 (start address=32, end address= 48, read data=8,9,10,11,12)
// The fourth and last chunk has a length of 2 (start address=52, end address= 56, read data=13,14).
//
// On the response side, for each response, the master releases the response channel after a delay of 3 nanoseconds
//
// ============================================================================


#ifndef _OCP_TL1_MASTER_H
#define _OCP_TL1_MASTER_H

#include "systemc.h"
#include "ocp_globals.h"
#include "ocp_tl1_data_cl.h"
#include "ocp_tl1_master_port.h"
#include "ocp_tl_param_cl.h"

// could be used to configure the data class, not needed in this example
#ifndef TL_SYNCHRON_DATA_CL
#define TL_SYNCHRON_DATA_CL true
#endif

template <class TdataCl_tl1> class OCP_TL1_Master
  : public sc_module
{
public:  
  
  typedef typename TdataCl_tl1::DataType Td;
  typedef typename TdataCl_tl1::AddrType Ta;

  OCP_TL1_MasterPort< TdataCl_tl1> MasterP;
  sc_in_clk  clk;

  SC_HAS_PROCESS(OCP_TL1_Master);

  // constructor
  OCP_TL1_Master(sc_module_name name_
             , int ID
             , int Priority
             , double DelayPct
            );

  // destructor
  ~OCP_TL1_Master();

  // methods
  virtual bool SputDirect(int, bool, Td*, Ta, int);
  void MasterRequest();
  void MasterResponse();


private :

  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl_tl1          *m_DataCl;
  ParamCl<TdataCl_tl1> *m_ParamCl;

  // parameters
  int m_ID;
  int m_Priority;
  double m_DelayPct;
};

#endif // _OCP_TL1_MASTER_H
