// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//
//  Description : Transaction Level - Layer-0 to Layer-1 Master Adapter (OCP 2.0)
//               (with Datahandshake support)
//  $Id: ocp2_tl0_tl1_master_adapter.h,v 1.3 2006/01/30 22:08:03 halexan Exp $
//  
// ============================================================================

#ifndef _OCP2_TL0_TL1_MASTER_ADAPTER_H
#define _OCP2_TL0_TL1_MASTER_ADAPTER_H

#include "ocp_globals.h"
#include "ocp_tl1_master_port.h"
#include "ocp_tl0_port.h"
#include <vector>

class OCPParameters;
template <typename TdataCl>
class OCP2_TL0_TL1_Master_Adapter : public sc_module
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // TL1 Master Port
  OCP_TL1_MasterPort<TdataCl> MasterP;

  // TL0 Basic OCP Slave ports
  sc_in_clk             Clk;
  OCP2_TL0_SlavePorts&   m_tl0Ports;

  SC_HAS_PROCESS(OCP2_TL0_TL1_Master_Adapter);

  // Constructor: specify tl0 interface class pointer
  OCP2_TL0_TL1_Master_Adapter(sc_module_name name_ ,
                              const OCP_TL0_PortFactory<OCP2_TL0_SlavePorts>&,
                              bool checkSetupTime = true,
                              bool combinational  = true);

  // destructor
  ~OCP2_TL0_TL1_Master_Adapter();

  // methods
  virtual bool SputDirect(int, bool, Td*, Ta, int);
  void send_Request();
  void send_Data();
  void set_reset_SCmdAccept_PE();
  void set_SCmdAccept_Normal();
  void reset_SCmdAccept_Normal();
  void set_reset_SDataAccept_PE();
  void set_SDataAccept_Normal();
  void reset_SDataAccept_Normal();
  void set_TL0_SThreadBusy();
  void set_TL0_SDataThreadBusy();
  void reset_TL0_signals();
  void set_TL1_ThreadBusy();
  void send_SReset();
  void send_MReset();
  void send_Response();
  void release_Response();
  void sample_events_trigger();
  //
  void setClockPeriod ( const sc_time& );
  void setSampleDelays( const sc_time&, const sc_time&, const sc_time& );
  void check_respaccept_setup_time();
  void check_request_setup_time();

private :
  void end_of_elaboration();
  
  // Structures used to handle TL1 Requests/Responses
  OCPResponseGrp<Td>   TL1_response;
  OCPRequestGrp<Td,Ta>   TL1_request;
  OCPDataHSGrp<Td>   TL1_dataHS ;
  
  // Pointer to the communication class of the channel
  CommCl           *m_CommCl;

  // Pointer to the parameter class of the channel
  OCPParameters    *m_ParamCl;

  // parameters
  sc_event e_request_sample_event;
  sc_event e_respaccept_sample_event;
  sc_event e_threadbusy_sample_event;
  sc_time m_request_sample_delay;
  sc_time m_respaccept_sample_delay;
  sc_time m_threadbusy_sample_delay;
  bool m_check_active;
  sc_time m_last_rising_edge;
  bool m_default_values;
  bool m_response_in_progress;
  bool m_request_PE_mode;
  bool m_datahs_PE_mode;
  bool m_request_accepted;
  bool m_ready_for_request;
  bool m_datahs_accepted;
  bool m_ready_for_datahs;

  // Burst Sequence Type of the current burst in progress
  // used to convert OCP1.0 bursts for the OCP 2.0 TL1 channel
  vector<OCPMBurstSeqType> m_curBurstSeq;
};

#endif // _OCP2_TL0_TL1_MASTER_ADAPTER_H
