// 
//  Copyright 2005 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: master.cc,v 1.2 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Master::Master (sc_module_name name_): 
  sc_module (name_), ipP("ipPort") {

  // initialize common members
  tmp = 0;
  cnt = 0;
  req.MData = 0;
  req.MAddr = 0;
  req.MByteEn = 0xF;
  addr = 0;
  SC_METHOD(proc);
  sensitive_pos(clk); 
  dont_initialize();
  
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Master::~Master() {}

// ----------------------------------------------------------------------------
//  Method : Master::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
void Master::proc() {

  // check if channel is free
  tmp = !ipP->getSBusy();
  if (tmp) {
    // Set OCP command type
    if (cnt&0x8) {
      req.MCmd = OCP_MCMD_RD;
      req.MBurstSeq = OCP_MBURSTSEQ_INCR;
      req.MAddr = addr & (~0x20); // write and read same addresses
      if ((addr&0x1F)==0x1C)
	req.MBurstLength = 1; // End of burst
      else
	req.MBurstLength = 2; // imprecise burst continues
    } 
    else {
      req.MCmd = OCP_MCMD_WR;
      req.MBurstSeq = OCP_MBURSTSEQ_INCR;
      req.MAddr = addr;
      if ((addr&0x1F)==0x1C)
	req.MBurstLength = 1; // End of burst
      else
	req.MBurstLength = 2; // imprecise burst continues
    }
    
    // Send request
    tmp = ipP->startOCPRequest(req);
    if (tmp) {
      
#ifdef DEBUG_G1
      cout << "Master sent request " << req.MCmd
	   << " time " << sc_time_stamp().to_seconds();
      if (req.MCmd == OCP_MCMD_WR) {
	cout << " data " << req.MData;
      }
      cout << endl;
#endif
      if (req.MCmd == OCP_MCMD_WR) 
	req.MData++;

      if (addr < 124)
	addr += 4;
      else
	addr = 0;
    
      cnt++;
    }
  }
  
  // Check for response
  tmp = ipP->getOCPResponse(resp, true);
  if (tmp) {
    if (resp.SResp == OCP_SRESP_DVA) {
#ifdef DEBUG_G1
      cout << "Master got valid response "
	   << "  time  = " << sc_time_stamp().to_seconds()
	   << "  data  = " << resp.SData << endl;
#endif
    }
  }
  
} // end of method



