// 
//  Copyright 2005 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: slave.h,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP -  TL1 profile example
//
// ============================================================================

#ifndef _OCP_TL1_SLAVE_SYNC_H
#define _OCP_TL1_SLAVE_SYNC_H

#define DEBUG_G1

#include <iostream>
#include "channel_types.h"

// OCP-IP Channel header files
#include "ocp_tl1_slave_port.h"
#include "ocp_tl_param_cl.h"
#include "fifo.h"

class Slave : public sc_module {
public:  

  typedef OCPCHANNELBit32 Td;
  typedef OCPCHANNELBit32 Ta;

  OCP_TL1_SlavePort<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > wP;
  OCP_TL1_SlavePort<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > rP;

  sc_in_clk clk;

  SC_HAS_PROCESS(Slave);

  // constructor
  Slave(sc_module_name name_);

  // destructor
  ~Slave();

  // Threads
  void proc_w();
  void proc_r();

  // OCP request group
  OCPRequestGrp<Td,Ta> req_w, req_r;

  // OCP request data group
  OCPDataHSGrp<Td> req_data;

  // OCP response group
  OCPResponseGrp<Td> resp_w, resp_r;

  fifo<Td, 8> req_fifo_w, req_fifo_r;
  fifo<Td, 8> resp_fifo_w;
  fifo<bool, 8> resp_fifo_r;

  bool is_req_w, is_req_r, is_data_w, is_data_r, request_w, request_r;
  bool not_accepted_w, not_accepted_r;

  Td bytemask;
  Td memory[1024];
  Ta address_w, address_r;
  bool burststart_w, burststart_r;
  int burstlen_w, burstlen_r;
};

#endif
