// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         $Id: slave_nb.cc,v 1.1 2005/05/21 00:37:51 anssi Exp $
//
//  Description : OCP API - Layer-1 non-blocking slave
// ============================================================================

#include "slave_nb.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
template<class TdataCl> SlaveNb<TdataCl>::SlaveNb (sc_module_name name_)
  : sc_module (name_), tpP("tpPort") {

  // initialize common members
  is_req = false;
  tmp = false;
  resp.SData = 0;
  last_request = OCP_MCMD_IDLE;

  SC_THREAD(proc);
  sensitive << clk;
}


// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
template<class TdataCl> SlaveNb<TdataCl>::~SlaveNb(){}


// ----------------------------------------------------------------------------
//  Method : SlaveNb::proc()
//
//  Synchronous slave process
//
// ----------------------------------------------------------------------------

template<class TdataCl> void SlaveNb<TdataCl>::proc(){
  while(1) {
    wait();
    is_req = tpP->getOCPRequest(req, true); // accept automatically
#ifdef DEBUG_G1
    if (is_req)
    cout << "SlaveNb got request "
	 << "  time  = " << sc_time_stamp().to_seconds()
	 << "  data  = " << req.MData << endl;
#endif
  }
} // end of method


// ----------------------------------------------------------------------------
//
//  Instantiation of the Slave
//
// ----------------------------------------------------------------------------
template class SlaveNb< OCP_TL1_SIGNAL_CL >; // see ocp_tl1_globals.h

