///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : James Aldis (TI France)
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :  Simple master for example.
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#ifndef _SIMPLE_MASTER_H
#define _SIMPLE_MASTER_H

// OCP-IP Channel header files
#include "ocpip.h"
#include "legacy_config_map.h"

// define the Master transactor class
template <unsigned int BUSWIDTH>
class Master : public sc_core::sc_module
{
  public:
    // --------------------------
    // public members and methods
    // --------------------------

    // channel port
    ocpip::ocp_master_socket_tl1<BUSWIDTH> ipP;
    sc_core::sc_in_clk clk;

    typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH,32>::DataType Td;
    typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH,32>::AddrType Ta;

    // SystemC macros
    // has SystemC processes
    SC_HAS_PROCESS(Master);

    // constructor and destructor
    Master(sc_core::sc_module_name,
           int, std::ostream* debug_os_ptr = NULL);
    ~Master();

    // methods
    void provideChannelConfiguration(map_string_type&);
    void setOCPTL1SlaveTiming(ocpip::ocp_tl1_slave_timing);
    void setModuleConfiguration(map_string_type&);

    // process methods
    void requestThreadProcess();
    void responseThreadProcess();
    //void exerciseSidebandThreadProcess();
    tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload& gp, tlm::tlm_phase& ph, sc_core::sc_time& t);

private:
    // ---------------------------
    // private members and methods
    // ---------------------------

    // SystemC methods
    void parse_config();

    // member definitions

    // master identification
    int          m_ID;

    //
    std::ostream* m_debug_os_ptr;

    // Parameters from the OCP Channel:

    // The number of threads
    int m_threads;

    // is MAddrSpace part of the OCP channel?
    bool m_addrspace;

    // is SThreadBusy part of the channel?
    bool m_sthreadbusy;

    // Is SThreadBusy compliance required?
    bool m_sthreadbusy_exact;

    // is MThreadBusy part of the channel?
    bool m_mthreadbusy;

    // Is MThreadBusy compliance required?
    bool m_mthreadbusy_exact;

    // is MRespAccept part of the channel?
    bool m_respaccept;

    // is Data Handshake part of the channel?
    bool m_datahandshake;

    // is write response part of the channel?
    bool m_writeresp_enable;

    // is the READ-EX command part of the channel
    bool m_readex_enable;

    // Are non-posted writes (write commands that receive responses)
    // part of the channel?
    bool m_writenonpost_enable;

    //-----------------------------------------
    //  Master Specific Parameters
    //-----------------------------------------

    // Response delay style - fixed or random
    bool m_respaccept_fixeddelay;

    // Delay in accepting responses (max delay for random)
    int m_respaccept_delay;

    // Map of string to string that holds the Master's paramter values
    ocpip::ocp_parameters m_parameters;

    sc_core::sc_time m_sthreadbusy_sample_time;
    sc_core::sc_event req_ack_event, resp_event;

    //delta_signal<tlm::tlm_generic_payload*> m_resp_txn;
    tlm::tlm_generic_payload* m_resp_txn;
    tlm::tlm_generic_payload* tb_txn;
    ocpip::resp_thread_busy*       tb;
    tlm::tlm_phase tb_ph;

    unsigned int m_stb;
};

#endif // _SIMPLE_MASTER_H
