// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: master.cc,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Master::Master (sc_core::sc_module_name name_): 
  sc_core::sc_module (name_), ipP("ipPort", ocpip::ocp_master_socket_tl1<32>::mm_txn_with_data()) , ongoing_req(false), resp(NULL){

  // initialize common members
  cnt = 0;
  req=NULL;
  current_lock=NULL;
  wraplen = 0;
  localData = 0;
  addr = 0;
  read = false;
  burstcnt = 0;
  SC_METHOD(proc);
  sensitive<<clk.pos(); 
  dont_initialize();
  ipP.register_nb_transport_bw(this, &Master::nb_transport);
  ipP.activate_synchronization_protection();
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Master::~Master() {}

// ----------------------------------------------------------------------------
//  Method : Master::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
void Master::proc() {

  // check if channel is free
  if (!ongoing_req) {
    // Set OCP command type
    if (cnt < 16) { // Incrementing bursts
      if (cnt==0 | cnt==8){
        req=ipP.get_transaction();
        ipP.reserve_data_size(*req, 8*sizeof(Td));
        req->set_command((read)?tlm::TLM_READ_COMMAND:tlm::TLM_WRITE_COMMAND);
        ocpip::burst_sequence* b_seq;
        ipP.get_extension<ocpip::burst_sequence>(b_seq, *req);
        b_seq->value.sequence=ocpip::INCR;
        ipP.validate_extension<ocpip::burst_sequence>(*req);
        ocpip::burst_length* b_len;
        ipP.get_extension<ocpip::burst_length>(b_len, *req);
        b_len->value=8;
        ipP.validate_extension<ocpip::burst_length>(*req);
        req->set_byte_enable_ptr(NULL);
        req->set_streaming_width(8*sizeof(Td));
        req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);
        if (read)
          req->set_address(addr & (~0x20)); // write and read same addresses
        else
          req->set_address(addr);
        if (req->get_command() == tlm::TLM_WRITE_COMMAND){
          ipP.validate_extension<ocpip::posted>(*req);
          for (int i=0; i<8; i++)
            *(((Td*)(req->get_data_ptr()))+i)=localData++;
        }
      }
      if (read) {
        if (burstcnt==7) {
          read = false;
          burstcnt=0;
        }
        else {
          burstcnt++;
        }
      } 
      else {
        if (burstcnt==7) {
          read = true;
          burstcnt=0;
        }
        else {
          burstcnt++;
        }	
      }
    }
    // ReadEx - Write
    else if (cnt < 17) {
      burstcnt=1;
      req=ipP.get_transaction();
      check_locks.push_back(req);
      //unlock_req=ipP.get_transaction();
      current_lock=my_lock_object::get_pool()->create();
      current_lock->lock_is_understood_by_slave=false;
      ipP.reserve_data_size(*req, sizeof(Td));
      req->set_command(tlm::TLM_READ_COMMAND);
      ocpip::burst_sequence* b_seq;
      ipP.get_extension<ocpip::burst_sequence>(b_seq, *req);
      b_seq->value.sequence=ocpip::INCR;
      ipP.validate_extension<ocpip::burst_sequence>(*req);
      ocpip::lock* lck;
      ipP.get_extension<ocpip::lock>(lck, *req);
      lck->value=current_lock;
      ipP.validate_extension<ocpip::lock>(*req); //readex
      req->set_address(addr);
      req->set_byte_enable_ptr(NULL);
      req->set_streaming_width(sizeof(Td));
      req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);      
    }
    else if (cnt < 18) {  // correct readex-write
      //req=unlock_req;
      req=ipP.get_transaction();
      ipP.reserve_data_size(*req, sizeof(Td));
      req->set_command(tlm::TLM_WRITE_COMMAND);
      ipP.validate_extension<ocpip::posted>(*req);
      ocpip::burst_sequence* b_seq;
      ipP.get_extension<ocpip::burst_sequence>(b_seq, *req);
      b_seq->value.sequence=ocpip::INCR;
      ipP.validate_extension<ocpip::burst_sequence>(*req);
      ocpip::lock* lck;
      ipP.get_extension<ocpip::lock>(lck, *req);
      lck->value=current_lock;
      ipP.validate_extension<ocpip::lock>(*req); //unlocking write      
      req->set_address(addr-4);
      req->set_byte_enable_ptr(NULL);
      req->set_streaming_width(sizeof(Td));
      req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);
      *((Td*)(req->get_data_ptr()))=localData++;
    }
    else if (cnt < 19) {
      req=ipP.get_transaction();
      check_locks.push_back(req);
      current_lock=my_lock_object::get_pool()->create();
      current_lock->lock_is_understood_by_slave=false;      
      //unlock_req=ipP.get_transaction();
      ipP.reserve_data_size(*req, sizeof(Td));
      req->set_command(tlm::TLM_READ_COMMAND);
      ocpip::burst_sequence* b_seq;
      ipP.get_extension<ocpip::burst_sequence>(b_seq, *req);
      b_seq->value.sequence=ocpip::INCR;
      ipP.validate_extension<ocpip::burst_sequence>(*req);
      ocpip::lock* lck;
      ipP.get_extension<ocpip::lock>(lck, *req);
      lck->value=current_lock;      
      ipP.validate_extension<ocpip::lock>(*req); //readex
      req->set_address(addr);
      req->set_byte_enable_ptr(NULL);
      req->set_streaming_width(sizeof(Td));
      req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);      
    }
    else if (cnt < 20) {  // incorrect after readex
      req=ipP.get_transaction();
      ipP.reserve_data_size(*req, sizeof(Td));
      req->set_command(tlm::TLM_READ_COMMAND);
      ocpip::burst_sequence* b_seq;
      ipP.get_extension<ocpip::burst_sequence>(b_seq, *req);
      b_seq->value.sequence=ocpip::INCR;
      ipP.validate_extension<ocpip::burst_sequence>(*req);
      req->set_address(addr);
      req->set_byte_enable_ptr(NULL);
      req->set_streaming_width(sizeof(Td));
      req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);      
    }
    else if (cnt < 21) {  // release last lock
      //req=unlock_req;
      req=ipP.get_transaction();
      ipP.reserve_data_size(*req, sizeof(Td));
      req->set_command(tlm::TLM_WRITE_COMMAND);
      ipP.validate_extension<ocpip::posted>(*req);
      ocpip::burst_sequence* b_seq;
      ipP.get_extension<ocpip::burst_sequence>(b_seq, *req);
      b_seq->value.sequence=ocpip::INCR;
      ipP.validate_extension<ocpip::burst_sequence>(*req);
      ocpip::lock* lck;
      ipP.get_extension<ocpip::lock>(lck, *req);
      lck->value=current_lock;      
      ipP.validate_extension<ocpip::lock>(*req); //unlocking write      
      req->set_address(addr-8);
      req->set_byte_enable_ptr(NULL);
      req->set_streaming_width(sizeof(Td));
      req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);
      *((Td*)(req->get_data_ptr()))=localData++;     
    }
    else { // Wrapping bursts
      if (burstcnt==0){
        req=ipP.get_transaction();
        ipP.reserve_data_size(*req, 8*sizeof(Td));
        req->set_command((read)?tlm::TLM_READ_COMMAND:tlm::TLM_WRITE_COMMAND);
        ocpip::burst_sequence* b_seq;
        ipP.get_extension<ocpip::burst_sequence>(b_seq, *req);
        b_seq->value.sequence=ocpip::WRAP;
        b_seq->value.xor_wrap_address=0x54;
        ipP.validate_extension<ocpip::burst_sequence>(*req);
        ocpip::burst_length* b_len;
        ipP.get_extension<ocpip::burst_length>(b_len, *req);
        b_len->value=8;
        ipP.validate_extension<ocpip::burst_length>(*req);
        req->set_byte_enable_ptr(NULL);
        req->set_streaming_width(8*sizeof(Td));
        req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);
        //wrap: 0x54, 0x58, 0x5C, 0x40, 0x44, 0x48, 0x4C, 0x50
        req->set_address(0x40);
        if (req->get_command() == tlm::TLM_WRITE_COMMAND){
          ipP.validate_extension<ocpip::posted>(*req);
          for (int i=5; i<13; i++){ 
            *(((Td*)(req->get_data_ptr()))+((i<8)?i:(i-8)))=localData++;                         
          }
        }
      }
      wraplen = 8;
      if (read) {
        if (burstcnt==7) {
          read = false;
          burstcnt=0;
        }
        else {
          burstcnt++;
        }
      } 
      else {
        if (burstcnt==7) {
          read = true;
          burstcnt=0;
        }
        else {
          burstcnt++;
        }
      }
    }
    
    if (cnt==20) burstcnt=0;
    // Send request
    time=sc_core::SC_ZERO_TIME;
    phase=tlm::BEGIN_REQ;
    tlm::tlm_sync_enum retVal = ipP->nb_transport_fw(*req, phase, time);
    switch(retVal){
      case tlm::TLM_ACCEPTED: ongoing_req=true; break;
      case tlm::TLM_UPDATED: 
        switch (phase){
          case tlm::END_REQ:
            if (cnt<16 | cnt>20) {//burst transfers
              if (!read && burstcnt==0) ipP.release_transaction(req); //we are done since there are no write resps
            }
            else //single beats
              if (!read) ipP.release_transaction(req); //we are done since there are no write resps
            break;
          default:
            std::cerr<<"Error in "<<name()<<" : got unexpected phase update to "<<phase<<" in response to BEGIN_REQ."<<std::endl;
            exit(1);                
        }
        break;
      case tlm::TLM_COMPLETED:;
    }
    
    if (req->get_command()==tlm::TLM_READ_COMMAND){
      if (cnt<16 | cnt>20){
        expected_rsps.push_back(expected_rsp(req, (((burstcnt)?burstcnt:8)-1), burstcnt==0));
      }
      else 
        expected_rsps.push_back(expected_rsp(req, 0, true));
    }
    
#ifdef DEBUG_G1
      std::cout << "Master sent request " << req->get_command()
	   << " time " << sc_core::sc_time_stamp().to_seconds();
      if (req->get_command() == tlm::TLM_WRITE_COMMAND) {
        std::cout <<" "<<burstcnt<<" data " << (*(((Td*)(req->get_data_ptr()))+(((burstcnt)?burstcnt:8)-1)));
      }
      std::cout << std::endl;
#endif

      // Address generator
      if (wraplen) {
        if ((addr+4) < ((addr & (~(wraplen-1)*4))+ wraplen*4))
          addr = addr+4; 
        else
          addr = addr & (~((wraplen-1)*4));
      }
      else
        if (addr < 124)
          addr += 4;
        else
          addr = 0;
      cnt++;
  }
  
  // Check for response
  if (resp) {
    assert(resp==expected_rsps.front().txn);
    if (check_locks.size() && resp==check_locks.front()){
      ocpip::lock* lck;
      ipP.get_extension(lck, *resp);
      if (!lck->value->lock_is_understood_by_slave){
        std::cerr<<"Modelling error: End target does not understand locks."<<std::endl;
      }
#ifdef DEBUG_G1
      else
        std::cout<<"Slave understands locks! Phew!"<<std::endl;
#endif
      check_locks.pop_front();
    }
#ifdef DEBUG_G1
    if (resp->get_response_status() == tlm::TLM_OK_RESPONSE) {
      std::cout << "Master got valid response "
	   << "  time  = " << sc_core::sc_time_stamp().to_seconds()
	   << "  data  = " << (*(((Td*)(resp->get_data_ptr()))+expected_rsps.front().chunk)) << std::endl;
    }
    else{
      std::cout << "Master got error response "
	   << "  time  = " << sc_core::sc_time_stamp().to_seconds()
	   << "  data  = " << (*(((Td*)(resp->get_data_ptr()))+expected_rsps.front().chunk)) << std::endl;
    }
#endif    
    if (expected_rsps.front().last) {
      ipP.release_transaction(resp); //we are done with this txn now
    }
    resp=NULL;
    expected_rsps.pop_front();
  }
  
} // end of method

tlm::tlm_sync_enum Master::nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim) {
  switch(ph){
    case tlm::END_REQ:
      ongoing_req=false;
      if (cnt<16 | cnt>20) {//burst transfers
        if (txn.get_command()==tlm::TLM_WRITE_COMMAND && burstcnt==0) ipP.release_transaction(req); //we are done since there are no write resps
      }
      else //single beats
        if (txn.get_command()==tlm::TLM_WRITE_COMMAND) ipP.release_transaction(req); //we are done since there are no write resps
      break;
    case tlm::BEGIN_RESP: resp=&txn;
      ph=tlm::END_RESP;
      return tlm::TLM_UPDATED; //there is no resp accept control flow
      break;
    default:
      std::cerr<<"Error in "<<name()<<" : got unexpected phase "<<ph<<" in nb_transport_bw"<<std::endl;
      exit(1);
  }
  return tlm::TLM_ACCEPTED;
}
