// 
//  Copyright 2008 OCP-IP
//  OCP-IP Confidential and Proprietary
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//         $Id: main.cc,v 1.6 2006/02/25 03:01:05 Anssi Exp $
//
//  Description : OCP API - Layer-1 Simple Example
//                Top level, synchronous Master <---> synchronous Slave
//
// ============================================================================

// Turn on user messages
//#define DEBUG_G1

// Turn off OCP protocol checker, if installed
//#define NDEBUG

// Include SystemC
#include "systemc"

// Include OCP files
#include "ocpip.h"
// Include user-defined headers
#include "command_line.h"

// Include submodules
#include "generic_stl_master_tl1.h"
#include "generic_mem_slave_tl1.h"

SC_MODULE( Top ) {
    sc_core::sc_clock clk;
    // Submodules
    ocpip_example::generic_mem_slave_tl1 <32> sl1;
    ocpip_example::generic_stl_master_tl1<32> ms1;
#ifdef USE_OCP_MONITOR
    ocpip::ocp_connection_monitor<32> ocp_monitor_t_piece;
    ocpip::ocp_tl1_monitor_adapter<32,32> mon_adapt;  
    ocpip_legacy::OCP_TL1_Trace_Monitor_Clocked<ocpip::ocp_data_class_unsigned<32,32> > tracer;
#endif

    Top( sc_core::sc_module_name name, int argc, char* argv[] ) :
	sc_core::sc_module( name )
	, clk( "clk", 1, sc_core::SC_NS )
	, sl1( "sl1" )
	, ms1( "ms1" )
#ifdef USE_OCP_MONITOR
	, ocp_monitor_t_piece(ms1.m_socket, sl1.m_socket)
	, mon_adapt(ocp_monitor_t_piece)
	, tracer("Tracer", "ocp0.ocp")
#endif
{
	// OCP parameters from command line
	map_string_type  ocpParamMap;
	std::string ocpParamFileName = "ocpParams"; // default
	process_command_line(argc,argv,ocpParamFileName);
	if ( ! ocpParamFileName.empty() ) {
	    readMapFromFile(ocpParamFileName, ocpParamMap);
	}

	// Set OCP configuration
	ocpip::ocp_parameters params;
	params=create_ocp_configuration_from_map("sl1", ocpParamMap);
	sl1.m_socket.set_ocp_config(params);
	ms1.m_socket.set_ocp_config(params);
	ms1.set_period( clk.period() );

#ifdef USE_OCP_MONITOR
	tracer.p_mon(mon_adapt);
	tracer.p_clk(clk);
#else
	ms1.m_socket(sl1.m_socket);
#endif
	ms1.m_clk(clk);
	sl1.m_clk(clk);
    }
};

#ifdef NCSC
NCSC_MODULE_EXPORT( Top )
#endif

int sc_main(int argc, char* argv[]) {
    scv_random::set_global_seed(22);
    Top top( "top", argc, argv );
    // Simulator
    sc_core::sc_start(200, sc_core::SC_NS);   
    return(0);
}

template class ocpip_example::generic_stl_master_tl1<32>;
template class ocpip_example::generic_stl_master_tl3<32>;
template class ocpip_example::generic_mem_slave_tl1 <32>;
template class ocpip_example::generic_mem_slave_tl3 <32>;
