// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Albert Chitemyan, Sonics Inc.
//                
//         $Id: 
//
//  Description : OCP - TL2 example Master
//
// ============================================================================

#ifndef _OCP_TL2_MASTER
#define _OCP_TL2_MASTER

// Turn on debug messages
#define DEBUG_TL2
#include <iostream>
//#include "stdlib.h"

// OCP-IP Channel header files
#include "ocpip.h"
#include "scv.h"

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH>
class Master : public sc_core::sc_module
{
public:  
  typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH, ADDRWIDTH>::DataType Td;
  typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH, ADDRWIDTH>::AddrType Ta;

  // channel port
  ocpip::ocp_master_socket_tl2<32> ip_socket;

  SC_HAS_PROCESS(Master);

  // constructor
  Master(sc_core::sc_module_name name_);

  // destructor
  ~Master();

  // methods
  void sendBurst();
  void receiveResp();
  
  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);

  void generate_burst(); 
  unsigned int burst_len_list[3];
  unsigned int burst_len;
  int transaction_count;

  // Request group
  tlm::tlm_generic_payload* req;
  tlm::tlm_phase phase;
  sc_core::sc_time time;
  sc_core::sc_time resp_delay;    
  
  bool ongoing_req;
  tlm::tlm_generic_payload* rsp;
  sc_core::sc_event send_burst_ev;
  sc_core::sc_event receive_resp_ev;

  unsigned int dataCnt, addrCnt;

};


#endif // _OCP_TL2_MASTER
