// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Albert Chitemyan, Sonics Inc.
//                
//         $Id: 
//
//  Description : OCP - TL2 example Master
//
// ============================================================================

#ifndef _OCP_TL2_MASTER
#define _OCP_TL2_MASTER

// Turn on debug messages
#define DEBUG_TL2
#include <iostream>

// OCP-IP Channel header files
#include "ocpip.h"
#include "scv.h"

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH>
class Master : public sc_core::sc_module
{
public:  
  typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH, ADDRWIDTH>::DataType Td;
  typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH, ADDRWIDTH>::AddrType Ta;

  // channel port
  ocpip::ocp_master_socket_tl2<32> ip_socket;

  // TL1 clock
  sc_core::sc_in_clk  clk;

  SC_HAS_PROCESS(Master);

  // constructor
  Master(sc_core::sc_module_name name_);

  // destructor
  ~Master();

  // threads
  void proc();
  
  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);

  void generate_burst(); 
  unsigned int burst_len_list[3];
  unsigned int burst_len;
  int transaction_count;

  // Request group
  tlm::tlm_generic_payload* req;
  tlm::tlm_phase phase;
  sc_core::sc_time time;
  
  bool ongoing_req;
  bool wait_for_burst_end;
  unsigned int burst_duration;

  tlm::tlm_generic_payload* rsp;

  unsigned int dataCnt, addrCnt;

  // TL2 timing annotations
  tlm::tlm_generic_payload*  timing_txn;
  ocpip::tl2_timing*         timing_ext;
  tlm::tlm_phase             timing_ph;

  unsigned int req_send_interval;

  void send_timing_info();
  void process_waiting_for_burst_end();
 
  void print_burst();
};


#endif // _OCP_TL2_MASTER
