// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Albert Chitemyan, Sonics Inc.
//                
//         $Id: 
//
//  Description : OCP - TL2 example Master
//
// ============================================================================

#ifndef _OCP_TL2_MASTER
#define _OCP_TL2_MASTER

// Turn on debug messages
#define DEBUG_TL2
#include <iostream>
#include "stdlib.h"

// OCP-IP Channel header files
#include "ocpip.h"


template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH>
class Master : public sc_core::sc_module
{
public:  
  typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH, ADDRWIDTH>::DataType Td;
  typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH, ADDRWIDTH>::AddrType Ta;

  // channel port
  ocpip::ocp_master_socket_tl2<32> ip_socket;

  // TL1 clock
  sc_core::sc_in_clk  clk;

  SC_HAS_PROCESS(Master);

  // constructor
  Master(sc_core::sc_module_name name_);

  // destructor
  ~Master();

  // threads
  void proc();
  
  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);

  // utility functions to generate burst
  void generate_write_burst(); 
  void generate_read_burst(); 
  void allocate_transaction(tlm::tlm_command cmd, unsigned int burst_len); 

  unsigned int burst_len;
  int transaction_count;
  unsigned int write_data[8];
  bool write_burst_done;

  // request word count related variables
  ocpip::word_count* word_count_info; 
  unsigned int chunk_counter;
  unsigned int sent_word_cnt;

  // Request group
  tlm::tlm_generic_payload* req;
  tlm::tlm_phase            phase;
  sc_core::sc_time          time;
  
  bool ongoing_req;
  tlm::tlm_generic_payload* rsp;
};


#endif // _OCP_TL2_MASTER
