// 
//  (c) Copyright OCP-IP 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Architectural Transaction Level Modeling
//       Author : Tim Kogel, CoWare Inc.
//         $Id: 
//
//  Description : declaration of simple OCP TL3 master,
//		  SCV based randomization of transactions and timing,
//		  uses implicit delay annotation of OCP_TL2_MasterIF
//
// ============================================================================

#include "ocp_tl3_master.h"
using namespace std;
using namespace sc_core;

ocp_tl3_master::ocp_tl3_master(sc_module_name mod):
  sc_core::sc_module(mod), 
  ocp("OcpP", ocpip::ocp_master_socket_tl3<>::mm_txn_with_data()),
  m_count_sent(0),
  m_count_received(0)
{
  m_sptr_req_gap = 10;
  m_sptr_resp_accept = 5;
  m_sptr_address = 0;
  m_sptr_data = 0;
  m_sptr_is_read = true;
  m_req = NULL;
  m_one_ns=sc_core::sc_time(1, sc_core::SC_NS);
  m_supress_eresp=false;

  // declare my sensitive methods
  SC_METHOD(send_request_method);
  sensitive<<m_next_req;
  
  ocp.register_nb_transport_bw(this, &ocp_tl3_master::nb_transport
#ifdef OCP_TL3_MASTER_USE_PEQ  
    , true
#endif
    );

#ifdef OCP_TL3_MASTER_USE_PEQ 
  m_resp = NULL;
  SC_METHOD(acc_response_method);
  sensitive<<m_resp_event;
  dont_initialize();
#endif
    

}

ocp_tl3_master::~ocp_tl3_master()
{
  cout << name() << " sent : " << m_count_sent 
       << ", received : " << m_count_received << endl;
}

void
ocp_tl3_master::send_request_method()
{
    m_sptr_req_gap = 10 + (m_sptr_req_gap+1)%10;
    m_sptr_is_read = !m_sptr_is_read;
    m_sptr_address = (m_sptr_address+1)%0x500;

    assert(m_req==NULL);

    m_req=ocp.get_transaction();
    ocp.reserve_data_size(*m_req, sizeof(unsigned int));
    m_req->set_address(m_sptr_address);
    m_req->set_byte_enable_ptr(NULL);
    m_req->set_streaming_width(sizeof(unsigned int));
    m_req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);

    if (m_sptr_is_read) {
      m_req->set_command(tlm::TLM_READ_COMMAND);
    } else {
      m_req->set_command(tlm::TLM_WRITE_COMMAND);
      ocp.validate_extension<ocpip::posted>(*m_req);
      *(m_req->get_data_ptr())=m_sptr_address;
    }
    m_ph=tlm::BEGIN_REQ;
    m_time=m_one_ns*m_sptr_req_gap;
#ifndef NDEBUG 
    std::cout << sc_core::sc_time_stamp() << ", " << sc_core::sc_module::name() 
	 << ", is " << (m_req->is_read()?"READ":"WRITE")
	 << " suspend for " << m_sptr_req_gap << " cycles\n";
#endif
    
    switch(ocp->nb_transport_fw(*m_req, m_ph, m_time)){
      case tlm::TLM_ACCEPTED: break;
      case tlm::TLM_UPDATED:
        switch(m_ph){
          case tlm::END_REQ: 
            m_next_req.notify(m_time);
            m_req=NULL;
            break;
          case tlm::BEGIN_RESP: //can only happen if we do not use PEQs
            m_next_req.notify(m_time);
            nb_transport(*m_req, m_ph, m_time);  //will release the txn   
            //we know the above call will return UPDATED and will change m_ph to END_RESP
            ocp->nb_transport_fw(*m_req, m_ph, m_time);
            m_req=NULL;            
            break;
          default: ;
        }
        break;
      case tlm::TLM_COMPLETED:
        m_ph=tlm::BEGIN_RESP;
        m_supress_eresp=true;
        nb_transport(*m_req, m_ph, m_time); //will set m_req to NULL and start next req  
        m_supress_eresp=false;
        break;      
    }
    m_count_sent++;
}

tlm::tlm_sync_enum
ocp_tl3_master::nb_transport(tlm::tlm_generic_payload& gp, tlm::tlm_phase& ph, sc_core::sc_time& t)
{
  switch(ph){
    case tlm::END_REQ:
      assert(m_req && "END_REQ without outstanding request.");
      m_next_req.notify(t);
      m_req=NULL;
      return tlm::TLM_ACCEPTED;
    case tlm::BEGIN_RESP:
      if (m_req==&gp){ //this req has not yet seen an end_req
        m_req=NULL;
        m_next_req.notify(t);
      }
      m_sptr_resp_accept = 5 + (m_sptr_resp_accept+1)%5;
#ifndef NDEBUG 
      std::cout << sc_core::sc_time_stamp()+t << " get_response_method " << sc_core::sc_module::name() 
           << " in " << m_sptr_resp_accept << " cycles\n";
#endif
      m_time=m_one_ns*m_sptr_resp_accept;
      t+=m_time;
      m_count_received++;
#ifdef OCP_TL3_MASTER_USE_PEQ
      if (!m_supress_eresp){
        assert(m_resp==NULL);
        m_resp=&gp;
        m_resp_event.notify(t);       
      }
#else
      ocp.release_transaction(&gp);
      ph=tlm::END_RESP;
      return tlm::TLM_UPDATED;
#endif
    default:; //ignorable phase
  }
  return tlm::TLM_ACCEPTED;
}

#ifdef OCP_TL3_MASTER_USE_PEQ  
void
ocp_tl3_master::acc_response_method(){
  m_ph=tlm::END_RESP;
  m_time=sc_core::SC_ZERO_TIME;
  ocp->nb_transport_fw(*m_resp, m_ph, m_time);
  ocp.release_transaction(m_resp);
  m_resp=NULL;
}
#endif
