// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level Layer-1
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//         Date : 02/15/2003
//
//  Description : Transaction Level - Layer-1 example Master
//               (with Datahandshake support)
// ============================================================================

#ifndef _OCP_TL1_MASTER_ASYNC_HS_H
#define _OCP_TL1_MASTER_ASYNC_HS_H

#include "ocp_tl1_globals.h"
#include "tl_master_if.h"

// could be used to configure the data class, not needed in this example
#ifndef TL_SYNCHRON_DATA_CL
#define TL_SYNCHRON_DATA_CL true
#endif

template <class TdataCl> class OCP_TL1_Master_Async_hs
  : public sc_module
  , public MdirectIF<TdataCl>
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  sc_port<TLmasterIF<TdataCl>, 1> MasterP;
  sc_in_clk  clk;

  SC_HAS_PROCESS(OCP_TL1_Master_Async_hs);

  // constructor
  OCP_TL1_Master_Async_hs(sc_module_name name_
             , int ID
             , int Priority
             , double RequestDelay
             , double DataDelay
             , double ResponseDelay
            );

  // destructor
  ~OCP_TL1_Master_Async_hs();

  // methods
  virtual bool SputDirect(int, bool, Td*, Ta, int);
  void MasterRequest();
  void MasterResponse();


private :

  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl          *m_DataCl;
  ParamCl<TdataCl> *m_ParamCl;
  CommCl           *m_CommCl;

  // parameters
  int m_ID;
  int m_Priority;
  double m_RequestDelay;
  double m_DataDelay;
  double m_ResponseDelay;
};


#endif // _OCP_TL1_MASTER_ASYNC_HS_H
